package org.wildfly.swarm.config.undertow.subsystem.configuration.connectionLimit;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Connection limiter handler
 */
@Address("/subsystem=undertow/configuration=filter/connection-limit=*")
public class ConnectionLimit<T extends ConnectionLimit> {

	private String key;
	private Integer maxConcurrentRequests;
	private Integer queueSize;

	public ConnectionLimit(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Maximum number of concurrent requests
	 */
	@ModelNodeBinding(detypedName = "max-concurrent-requests")
	public Integer maxConcurrentRequests() {
		return this.maxConcurrentRequests;
	}

	/**
	 * Maximum number of concurrent requests
	 */
	@SuppressWarnings("unchecked")
	public T maxConcurrentRequests(Integer value) {
		this.maxConcurrentRequests = value;
		return (T) this;
	}

	/**
	 * Number of requests to queue before they start being rejected
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * Number of requests to queue before they start being rejected
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(Integer value) {
		this.queueSize = value;
		return (T) this;
	}
}