package org.wildfly.swarm.config.undertow.subsystem.configuration.errorPage;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The error pages
 */
@Address("/subsystem=undertow/configuration=filter/error-page=*")
public class ErrorPage<T extends ErrorPage> {

	private String key;
	private Integer code;
	private String path;

	public ErrorPage(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Error page code
	 */
	@ModelNodeBinding(detypedName = "code")
	public Integer code() {
		return this.code;
	}

	/**
	 * Error page code
	 */
	@SuppressWarnings("unchecked")
	public T code(Integer value) {
		this.code = value;
		return (T) this;
	}

	/**
	 * Error page path
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Error page path
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		this.path = value;
		return (T) this;
	}
}