package org.wildfly.swarm.config.undertow.subsystem.server.host;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The SSO configuration for this virtual server.
 */
@Address("/subsystem=undertow/server=*/host=*/setting=single-sign-on")
@Implicit
public class SettingSingleSignOn<T extends SettingSingleSignOn> {

	private String key;
	private String cookieName;
	private String domain;
	private Boolean httpOnly;
	private String path;
	private Boolean secure;

	public SettingSingleSignOn() {
		this.key = "single-sign-on";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Name of the cookie
	 */
	@ModelNodeBinding(detypedName = "cookie-name")
	public String cookieName() {
		return this.cookieName;
	}

	/**
	 * Name of the cookie
	 */
	@SuppressWarnings("unchecked")
	public T cookieName(String value) {
		this.cookieName = value;
		return (T) this;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@ModelNodeBinding(detypedName = "domain")
	public String domain() {
		return this.domain;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@SuppressWarnings("unchecked")
	public T domain(String value) {
		this.domain = value;
		return (T) this;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@ModelNodeBinding(detypedName = "http-only")
	public Boolean httpOnly() {
		return this.httpOnly;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@SuppressWarnings("unchecked")
	public T httpOnly(Boolean value) {
		this.httpOnly = value;
		return (T) this;
	}

	/**
	 * Cookie path.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Cookie path.
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		this.path = value;
		return (T) this;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@SuppressWarnings("unchecked")
	public T secure(Boolean value) {
		this.secure = value;
		return (T) this;
	}
}