package org.wildfly.swarm.config.undertow.subsystem.servletContainer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * If websockets are enabled for this container
 */
@Address("/subsystem=undertow/servlet-container=*/setting=websockets")
@Implicit
public class SettingWebsockets<T extends SettingWebsockets> {

	private String key;
	private String bufferPool;
	private Boolean dispatchToWorker;
	private String worker;

	public SettingWebsockets() {
		this.key = "websockets";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The buffer pool to use for websocket deployments
	 */
	@ModelNodeBinding(detypedName = "buffer-pool")
	public String bufferPool() {
		return this.bufferPool;
	}

	/**
	 * The buffer pool to use for websocket deployments
	 */
	@SuppressWarnings("unchecked")
	public T bufferPool(String value) {
		this.bufferPool = value;
		return (T) this;
	}

	/**
	 * If callbacks should be dispatched to a worker thread. If this is false then they will be run in the IO thread, which is faster however care must be taken not to perform blocking operations.
	 */
	@ModelNodeBinding(detypedName = "dispatch-to-worker")
	public Boolean dispatchToWorker() {
		return this.dispatchToWorker;
	}

	/**
	 * If callbacks should be dispatched to a worker thread. If this is false then they will be run in the IO thread, which is faster however care must be taken not to perform blocking operations.
	 */
	@SuppressWarnings("unchecked")
	public T dispatchToWorker(Boolean value) {
		this.dispatchToWorker = value;
		return (T) this;
	}

	/**
	 * The worker to use for websocket deployments
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * The worker to use for websocket deployments
	 */
	@SuppressWarnings("unchecked")
	public T worker(String value) {
		this.worker = value;
		return (T) this;
	}
}