/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.datasources.subsystem.dataSource.DataSource;
import org.wildfly.swarm.config.datasources.subsystem.jdbcDriver.JdbcDriver;
import org.wildfly.swarm.config.datasources.subsystem.xaDataSource.XaDataSource;

@Address(value="/subsystem=datasources")
@Implicit
public class Datasources<T extends Datasources> {
    private String key = "datasources";
    private List<Map> installedDrivers;
    private DatasourcesResources subresources = new DatasourcesResources();

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="installed-drivers")
    public List<Map> installedDrivers() {
        return this.installedDrivers;
    }

    public T installedDrivers(List<Map> value) {
        this.installedDrivers = value;
        return (T)this;
    }

    public DatasourcesResources subresources() {
        return this.subresources;
    }

    public T jdbcDrivers(List<JdbcDriver> value) {
        this.subresources.jdbcDrivers.addAll(value);
        return (T)this;
    }

    public T jdbcDriver(JdbcDriver value) {
        this.subresources.jdbcDrivers.add(value);
        return (T)this;
    }

    public T xaDataSources(List<XaDataSource> value) {
        this.subresources.xaDataSources.addAll(value);
        return (T)this;
    }

    public T xaDataSource(XaDataSource value) {
        this.subresources.xaDataSources.add(value);
        return (T)this;
    }

    public T dataSources(List<DataSource> value) {
        this.subresources.dataSources.addAll(value);
        return (T)this;
    }

    public T dataSource(DataSource value) {
        this.subresources.dataSources.add(value);
        return (T)this;
    }

    public class DatasourcesResources {
        private List<JdbcDriver> jdbcDrivers = new ArrayList<JdbcDriver>();
        private List<XaDataSource> xaDataSources = new ArrayList<XaDataSource>();
        private List<DataSource> dataSources = new ArrayList<DataSource>();

        @Subresource
        public List<JdbcDriver> jdbcDrivers() {
            return this.jdbcDrivers;
        }

        @Subresource
        public List<XaDataSource> xaDataSources() {
            return this.xaDataSources;
        }

        @Subresource
        public List<DataSource> dataSources() {
            return this.dataSources;
        }
    }
}

