/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.subsystem.server;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.subsystem.server.ajpListener.AjpListener;
import org.wildfly.swarm.config.undertow.subsystem.server.host.Host;
import org.wildfly.swarm.config.undertow.subsystem.server.httpListener.HttpListener;
import org.wildfly.swarm.config.undertow.subsystem.server.httpsListener.HttpsListener;

@Address(value="/subsystem=undertow/server=*")
public class Server<T extends Server> {
    private String key;
    private String defaultHost;
    private String servletContainer;
    private ServerResources subresources = new ServerResources();

    public Server(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="default-host")
    public String defaultHost() {
        return this.defaultHost;
    }

    public T defaultHost(String value) {
        this.defaultHost = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="servlet-container")
    public String servletContainer() {
        return this.servletContainer;
    }

    public T servletContainer(String value) {
        this.servletContainer = value;
        return (T)this;
    }

    public ServerResources subresources() {
        return this.subresources;
    }

    public T hosts(List<Host> value) {
        this.subresources.hosts.addAll(value);
        return (T)this;
    }

    public T host(Host value) {
        this.subresources.hosts.add(value);
        return (T)this;
    }

    public T httpListeners(List<HttpListener> value) {
        this.subresources.httpListeners.addAll(value);
        return (T)this;
    }

    public T httpListener(HttpListener value) {
        this.subresources.httpListeners.add(value);
        return (T)this;
    }

    public T ajpListeners(List<AjpListener> value) {
        this.subresources.ajpListeners.addAll(value);
        return (T)this;
    }

    public T ajpListener(AjpListener value) {
        this.subresources.ajpListeners.add(value);
        return (T)this;
    }

    public T httpsListeners(List<HttpsListener> value) {
        this.subresources.httpsListeners.addAll(value);
        return (T)this;
    }

    public T httpsListener(HttpsListener value) {
        this.subresources.httpsListeners.add(value);
        return (T)this;
    }

    public class ServerResources {
        private List<Host> hosts = new ArrayList<Host>();
        private List<HttpListener> httpListeners = new ArrayList<HttpListener>();
        private List<AjpListener> ajpListeners = new ArrayList<AjpListener>();
        private List<HttpsListener> httpsListeners = new ArrayList<HttpsListener>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        @Subresource
        public List<HttpListener> httpListeners() {
            return this.httpListeners;
        }

        @Subresource
        public List<AjpListener> ajpListeners() {
            return this.ajpListeners;
        }

        @Subresource
        public List<HttpsListener> httpsListeners() {
            return this.httpsListeners;
        }
    }
}

