package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.CacheContainer;
/**
 * The configuration of the infinispan subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class Infinispan<T extends Infinispan> {

	private String key;
	private InfinispanResources subresources = new InfinispanResources();

	public Infinispan() {
		this.key = "infinispan";
	}

	public String getKey() {
		return this.key;
	}

	public InfinispanResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.infinispan.CacheContainer objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.infinispan.CacheContainer objects.
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainers(
			List<org.wildfly.swarm.config.infinispan.CacheContainer> value) {
		this.subresources.cacheContainers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.infinispan.CacheContainer object to the list of subresources
	 * @param value The org.wildfly.swarm.config.infinispan.CacheContainer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(CacheContainer value) {
		this.subresources.cacheContainers.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Infinispan
	 */
	public class InfinispanResources {
		/**
		 * The configuration of an infinispan cache container
		 */
		private List<org.wildfly.swarm.config.infinispan.CacheContainer> cacheContainers = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.infinispan.CacheContainer resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CacheContainer> cacheContainers() {
			return this.cacheContainers;
		}
	}
}