package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The JSF subsystem
 */
@ResourceType("subsystem")
@Implicit
public class Jsf<T extends Jsf> {

	private String key;
	private String defaultJsfImplSlot;

	public Jsf() {
		this.key = "jsf";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Default JSF implementation slot
	 */
	@ModelNodeBinding(detypedName = "default-jsf-impl-slot")
	public String defaultJsfImplSlot() {
		return this.defaultJsfImplSlot;
	}

	/**
	 * Default JSF implementation slot
	 */
	@SuppressWarnings("unchecked")
	public T defaultJsfImplSlot(String value) {
		this.defaultJsfImplSlot = value;
		return (T) this;
	}
}