package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging_activemq.Server;
import org.wildfly.swarm.config.messaging_activemq.JmsBridge;
/**
 * The messaging-activemq subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class MessagingActivemq<T extends MessagingActivemq> {

	private String key;
	private MessagingActivemqResources subresources = new MessagingActivemqResources();

	public MessagingActivemq() {
		this.key = "messaging-activemq";
	}

	public String getKey() {
		return this.key;
	}

	public MessagingActivemqResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.Server objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.Server objects.
	 */
	@SuppressWarnings("unchecked")
	public T servers(
			List<org.wildfly.swarm.config.messaging_activemq.Server> value) {
		this.subresources.servers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.Server object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.Server to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(Server value) {
		this.subresources.servers.add(value);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.JmsBridge objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.JmsBridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridges(
			List<org.wildfly.swarm.config.messaging_activemq.JmsBridge> value) {
		this.subresources.jmsBridges.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.JmsBridge object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.JmsBridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(JmsBridge value) {
		this.subresources.jmsBridges.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for MessagingActivemq
	 */
	public class MessagingActivemqResources {
		/**
		 * An ActiveMQ server instance.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.Server> servers = new java.util.ArrayList<>();
		/**
		 * A JMS bridge instance.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.JmsBridge> jmsBridges = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.Server resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Server> servers() {
			return this.servers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.JmsBridge resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JmsBridge> jmsBridges() {
			return this.jmsBridges;
		}
	}
}