package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The configuration of the weld subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class Weld<T extends Weld> {

	private String key;
	private Boolean developmentMode;
	private Boolean nonPortableMode;
	private Boolean requireBeanDescriptor;

	public Weld() {
		this.key = "weld";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Weld comes with a special mode for application development. When the development mode is enabled, certain built-in tools, which facilitate the development of CDI applications, are available. Setting this attribute to true activates the development mode.
	 */
	@ModelNodeBinding(detypedName = "development-mode")
	public Boolean developmentMode() {
		return this.developmentMode;
	}

	/**
	 * Weld comes with a special mode for application development. When the development mode is enabled, certain built-in tools, which facilitate the development of CDI applications, are available. Setting this attribute to true activates the development mode.
	 */
	@SuppressWarnings("unchecked")
	public T developmentMode(Boolean value) {
		this.developmentMode = value;
		return (T) this;
	}

	/**
	 * If true then the non-portable mode is enabled. The non-portable mode is suggested by the specification to overcome problems with legacy applications that do not use CDI SPI properly and may be rejected by more strict validation in CDI 1.1.
	 */
	@ModelNodeBinding(detypedName = "non-portable-mode")
	public Boolean nonPortableMode() {
		return this.nonPortableMode;
	}

	/**
	 * If true then the non-portable mode is enabled. The non-portable mode is suggested by the specification to overcome problems with legacy applications that do not use CDI SPI properly and may be rejected by more strict validation in CDI 1.1.
	 */
	@SuppressWarnings("unchecked")
	public T nonPortableMode(Boolean value) {
		this.nonPortableMode = value;
		return (T) this;
	}

	/**
	 * If true then implicit bean archives without bean descriptor file (beans.xml) are ignored by Weld
	 */
	@ModelNodeBinding(detypedName = "require-bean-descriptor")
	public Boolean requireBeanDescriptor() {
		return this.requireBeanDescriptor;
	}

	/**
	 * If true then implicit bean archives without bean descriptor file (beans.xml) are ignored by Weld
	 */
	@SuppressWarnings("unchecked")
	public T requireBeanDescriptor(Boolean value) {
		this.requireBeanDescriptor = value;
		return (T) this;
	}
}