package org.wildfly.swarm.config.ee;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A managed executor service
 */
@ResourceType("managed-executor-service")
public class ManagedExecutorService {

	private String key;
	private String contextService;
	private Integer coreThreads;
	private Long hungTaskThreshold;
	private String jndiName;
	private Long keepaliveTime;
	private Boolean longRunningTasks;
	private Integer maxThreads;
	private Integer queueLength;
	private String rejectPolicy;
	private String threadFactory;

	public ManagedExecutorService(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the context service to be used by the executor.
	 */
	@ModelNodeBinding(detypedName = "context-service")
	public String contextService() {
		return this.contextService;
	}

	/**
	 * The name of the context service to be used by the executor.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService contextService(String value) {
		this.contextService = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * The minimum number of threads to be used by the executor. If left undefined the default core-size is calculated based on the number of processors. A value of zero is not advised and in some cases invalid. See the queue-length attribute for details on how this value is used to determine the queuing strategy.
	 */
	@ModelNodeBinding(detypedName = "core-threads")
	public Integer coreThreads() {
		return this.coreThreads;
	}

	/**
	 * The minimum number of threads to be used by the executor. If left undefined the default core-size is calculated based on the number of processors. A value of zero is not advised and in some cases invalid. See the queue-length attribute for details on how this value is used to determine the queuing strategy.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService coreThreads(Integer value) {
		this.coreThreads = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * The runtime, in milliseconds, for tasks to be considered hung by the managed executor service. If value is 0 tasks are never considered hung.
	 */
	@ModelNodeBinding(detypedName = "hung-task-threshold")
	public Long hungTaskThreshold() {
		return this.hungTaskThreshold;
	}

	/**
	 * The runtime, in milliseconds, for tasks to be considered hung by the managed executor service. If value is 0 tasks are never considered hung.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService hungTaskThreshold(Long value) {
		this.hungTaskThreshold = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * The JNDI Name to lookup the managed executor service.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The JNDI Name to lookup the managed executor service.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService jndiName(String value) {
		this.jndiName = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * When the number of threads is greater than the core, this is the maximum time, in milliseconds, that excess idle threads will wait for new tasks before terminating.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * When the number of threads is greater than the core, this is the maximum time, in milliseconds, that excess idle threads will wait for new tasks before terminating.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService keepaliveTime(Long value) {
		this.keepaliveTime = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * Flag which hints the duration of tasks executed by the executor.
	 */
	@ModelNodeBinding(detypedName = "long-running-tasks")
	public Boolean longRunningTasks() {
		return this.longRunningTasks;
	}

	/**
	 * Flag which hints the duration of tasks executed by the executor.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService longRunningTasks(Boolean value) {
		this.longRunningTasks = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * The maximum number of threads to be used by the executor. If left undefined the value from core-size will be used.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum number of threads to be used by the executor. If left undefined the value from core-size will be used.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService maxThreads(Integer value) {
		this.maxThreads = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * The executors task queue capacity. A length of 0 means direct hand-off and possible rejection will occur. An undefined length (the default), or Integer.MAX_VALUE, indicates that an unbounded queue should be used. All other values specify an exact queue size. If an unbounded queue or direct hand-off is used, a core-threads value greater than zero is required.
	 */
	@ModelNodeBinding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The executors task queue capacity. A length of 0 means direct hand-off and possible rejection will occur. An undefined length (the default), or Integer.MAX_VALUE, indicates that an unbounded queue should be used. All other values specify an exact queue size. If an unbounded queue or direct hand-off is used, a core-threads value greater than zero is required.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService queueLength(Integer value) {
		this.queueLength = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * The policy to be applied to aborted tasks.
	 */
	@ModelNodeBinding(detypedName = "reject-policy")
	public String rejectPolicy() {
		return this.rejectPolicy;
	}

	/**
	 * The policy to be applied to aborted tasks.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService rejectPolicy(String value) {
		this.rejectPolicy = value;
		return (ManagedExecutorService) this;
	}

	/**
	 * The name of the thread factory to be used by the executor.
	 */
	@ModelNodeBinding(detypedName = "thread-factory")
	public String threadFactory() {
		return this.threadFactory;
	}

	/**
	 * The name of the thread factory to be used by the executor.
	 */
	@SuppressWarnings("unchecked")
	public ManagedExecutorService threadFactory(String value) {
		this.threadFactory = value;
		return (ManagedExecutorService) this;
	}
}