package org.wildfly.swarm.config.ee;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A managed thread factory
 */
@ResourceType("managed-thread-factory")
public class ManagedThreadFactory {

	private String key;
	private String contextService;
	private String jndiName;
	private Integer priority;

	public ManagedThreadFactory(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the context service to be used by the managed thread factory
	 */
	@ModelNodeBinding(detypedName = "context-service")
	public String contextService() {
		return this.contextService;
	}

	/**
	 * The name of the context service to be used by the managed thread factory
	 */
	@SuppressWarnings("unchecked")
	public ManagedThreadFactory contextService(String value) {
		this.contextService = value;
		return (ManagedThreadFactory) this;
	}

	/**
	 * The JNDI Name to lookup the managed thread factory.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The JNDI Name to lookup the managed thread factory.
	 */
	@SuppressWarnings("unchecked")
	public ManagedThreadFactory jndiName(String value) {
		this.jndiName = value;
		return (ManagedThreadFactory) this;
	}

	/**
	 * The priority applied to threads created by the factory
	 */
	@ModelNodeBinding(detypedName = "priority")
	public Integer priority() {
		return this.priority;
	}

	/**
	 * The priority applied to threads created by the factory
	 */
	@SuppressWarnings("unchecked")
	public ManagedThreadFactory priority(Integer value) {
		this.priority = value;
		return (ManagedThreadFactory) this;
	}
}