package org.wildfly.swarm.config.ejb3;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A file system based passivation store
 */
@ResourceType("file-passivation-store")
public class FilePassivationStore {

	private String key;
	private Long idleTimeout;
	private Integer maxSize;

	public FilePassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@ModelNodeBinding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@SuppressWarnings("unchecked")
	public FilePassivationStore idleTimeout(Long value) {
		this.idleTimeout = value;
		return (FilePassivationStore) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public FilePassivationStore maxSize(Integer value) {
		this.maxSize = value;
		return (FilePassivationStore) this;
	}
}