package org.wildfly.swarm.config.ejb3;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Delivery group to manage delivery for mdbs
 */
@ResourceType("mdb-delivery-group")
public class MdbDeliveryGroup {

	private String key;
	private Boolean active;

	public MdbDeliveryGroup(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@SuppressWarnings("unchecked")
	public MdbDeliveryGroup active(Boolean value) {
		this.active = value;
		return (MdbDeliveryGroup) this;
	}
}