package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
/**
 * The remote backups for this cache.
 */
@ResourceType("component")
@Implicit
public class BackupsComponent {

	private String key;
	private BackupsComponentResources subresources = new BackupsComponentResources();

	public BackupsComponent() {
		this.key = "backups";
	}

	public String getKey() {
		return this.key;
	}

	public BackupsComponentResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.infinispan.cache_container.Backup objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.infinispan.cache_container.Backup objects.
	 */
	@SuppressWarnings("unchecked")
	public BackupsComponent backups(
			List<org.wildfly.swarm.config.infinispan.cache_container.Backup> value) {
		this.subresources.backups.addAll(value);
		return (BackupsComponent) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.infinispan.cache_container.Backup object to the list of subresources
	 * @param value The org.wildfly.swarm.config.infinispan.cache_container.Backup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public BackupsComponent backup(Backup value) {
		this.subresources.backups.add(value);
		return (BackupsComponent) this;
	}

	/**
	 * Child mutators for BackupsComponent
	 */
	public class BackupsComponentResources {
		/**
		 * A backup site to which to replicate this cache.
		 */
		private List<org.wildfly.swarm.config.infinispan.cache_container.Backup> backups = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.infinispan.cache_container.Backup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Backup> backups() {
			return this.backups;
		}
	}
}