package org.wildfly.swarm.config.jca;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
/**
 * DistributedWorkManager for resource adapters
 */
@ResourceType("distributed-workmanager")
public class DistributedWorkmanager {

	private String key;
	private String name;
	private String policy;
	private Map policyOptions;
	private String selector;
	private Map selectorOptions;
	private DistributedWorkmanagerResources subresources = new DistributedWorkmanagerResources();

	public DistributedWorkmanager(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the DistributedWorkManager
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the DistributedWorkManager
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager name(String value) {
		this.name = value;
		return (DistributedWorkmanager) this;
	}

	/**
	 * The policy decides when to redistribute a Work instance
	 */
	@ModelNodeBinding(detypedName = "policy")
	public String policy() {
		return this.policy;
	}

	/**
	 * The policy decides when to redistribute a Work instance
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager policy(String value) {
		this.policy = value;
		return (DistributedWorkmanager) this;
	}

	/**
	 * List of policy's options key/value pairs
	 */
	@ModelNodeBinding(detypedName = "policy-options")
	public Map policyOptions() {
		return this.policyOptions;
	}

	/**
	 * List of policy's options key/value pairs
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager policyOptions(Map value) {
		this.policyOptions = value;
		return (DistributedWorkmanager) this;
	}

	/**
	 * The selector decides to which nodes in the network to redistribute the Work instance to
	 */
	@ModelNodeBinding(detypedName = "selector")
	public String selector() {
		return this.selector;
	}

	/**
	 * The selector decides to which nodes in the network to redistribute the Work instance to
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager selector(String value) {
		this.selector = value;
		return (DistributedWorkmanager) this;
	}

	/**
	 * List of selector's options key/value pairs
	 */
	@ModelNodeBinding(detypedName = "selector-options")
	public Map selectorOptions() {
		return this.selectorOptions;
	}

	/**
	 * List of selector's options key/value pairs
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager selectorOptions(Map value) {
		this.selectorOptions = value;
		return (DistributedWorkmanager) this;
	}

	public DistributedWorkmanagerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.jca.LongRunningThreads objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.jca.LongRunningThreads objects.
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager longRunningThreads(
			List<org.wildfly.swarm.config.jca.LongRunningThreads> value) {
		this.subresources.longRunningThreads.addAll(value);
		return (DistributedWorkmanager) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.jca.LongRunningThreads object to the list of subresources
	 * @param value The org.wildfly.swarm.config.jca.LongRunningThreads to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager longRunningThreads(LongRunningThreads value) {
		this.subresources.longRunningThreads.add(value);
		return (DistributedWorkmanager) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.jca.ShortRunningThreads objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.jca.ShortRunningThreads objects.
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager shortRunningThreads(
			List<org.wildfly.swarm.config.jca.ShortRunningThreads> value) {
		this.subresources.shortRunningThreads.addAll(value);
		return (DistributedWorkmanager) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.jca.ShortRunningThreads object to the list of subresources
	 * @param value The org.wildfly.swarm.config.jca.ShortRunningThreads to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public DistributedWorkmanager shortRunningThreads(ShortRunningThreads value) {
		this.subresources.shortRunningThreads.add(value);
		return (DistributedWorkmanager) this;
	}

	/**
	 * Child mutators for DistributedWorkmanager
	 */
	public class DistributedWorkmanagerResources {
		/**
		 * A thread pool executor with a bounded queue where threads submittings tasks will not block. Such a thread pool has a core and maximum size and a specified queue length.  When a task is submitted, if the number of running threads is less than the core size, a new thread is created.  Otherwise, if there is room in the queue, the task is enqueued. Otherwise, if the number of running threads is less than the maximum size, a new thread is created. Otherwise, the task is handed off to the designated handoff executor, if one is specified.  Otherwise, the task is discarded.
		 */
		private List<org.wildfly.swarm.config.jca.LongRunningThreads> longRunningThreads = new java.util.ArrayList<>();
		/**
		 * A thread pool executor with a bounded queue where threads submittings tasks will not block. Such a thread pool has a core and maximum size and a specified queue length.  When a task is submitted, if the number of running threads is less than the core size, a new thread is created.  Otherwise, if there is room in the queue, the task is enqueued. Otherwise, if the number of running threads is less than the maximum size, a new thread is created. Otherwise, the task is handed off to the designated handoff executor, if one is specified.  Otherwise, the task is discarded.
		 */
		private List<org.wildfly.swarm.config.jca.ShortRunningThreads> shortRunningThreads = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.jca.LongRunningThreads resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LongRunningThreads> longRunningThreads() {
			return this.longRunningThreads;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.jca.ShortRunningThreads resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ShortRunningThreads> shortRunningThreads() {
			return this.shortRunningThreads;
		}
	}
}