package org.wildfly.swarm.config.messaging_activemq;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging_activemq.server.ConnectorService;
import org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor;
import org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection;
import org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup;
import org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue;
import org.wildfly.swarm.config.messaging_activemq.server.AddressSetting;
import org.wildfly.swarm.config.messaging_activemq.server.JmsQueue;
import org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging_activemq.server.Divert;
import org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor;
import org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup;
import org.wildfly.swarm.config.messaging_activemq.server.HttpConnector;
import org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory;
import org.wildfly.swarm.config.messaging_activemq.server.Acceptor;
import org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor;
import org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector;
import org.wildfly.swarm.config.messaging_activemq.server.InVmConnector;
import org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory;
import org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler;
import org.wildfly.swarm.config.messaging_activemq.server.JmsTopic;
import org.wildfly.swarm.config.messaging_activemq.server.Connector;
import org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting;
import org.wildfly.swarm.config.messaging_activemq.server.CoreAddress;
import org.wildfly.swarm.config.messaging_activemq.server.Bridge;
import org.wildfly.swarm.config.messaging_activemq.server.Queue;
import org.wildfly.swarm.config.messaging_activemq.server.SharedStoreColocatedHaPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.ReplicationMasterHaPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.SharedStoreMasterHaPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.BindingsDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.ReplicationColocatedHaPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.JournalDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.SharedStoreSlaveHaPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.PagingDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.LargeMessagesDirectoryPath;
import org.wildfly.swarm.config.messaging_activemq.server.LiveOnlyHaPolicy;
import org.wildfly.swarm.config.messaging_activemq.server.ReplicationSlaveHaPolicy;
/**
 * An ActiveMQ server instance.
 */
@ResourceType("server")
public class Server {

	private String key;
	private Boolean active;
	private Boolean asyncConnectionExecutionEnabled;
	private Long connectionTtlOverride;
	private Integer idCacheSize;
	private List<java.util.Map> incomingInterceptors;
	private List<java.util.Map> outgoingInterceptors;
	private Integer pageMaxConcurrentIo;
	private Boolean persistDeliveryCountBeforeDelivery;
	private Boolean persistIdCache;
	private Boolean persistenceEnabled;
	private Integer scheduledThreadPoolMaxSize;
	private Boolean started;
	private Integer threadPoolMaxSize;
	private String version;
	private Boolean wildCardRoutingEnabled;
	private String clusterPassword;
	private String clusterUser;
	private Long memoryMeasureInterval;
	private Integer memoryWarningThreshold;
	private Integer perfBlastPages;
	private Boolean runSyncSpeedTest;
	private Long serverDumpInterval;
	private Boolean createBindingsDir;
	private Boolean createJournalDir;
	private Long journalBufferSize;
	private Long journalBufferTimeout;
	private Integer journalCompactMinFiles;
	private Integer journalCompactPercentage;
	private Long journalFileSize;
	private Integer journalMaxIo;
	private Integer journalMinFiles;
	private Boolean journalSyncNonTransactional;
	private Boolean journalSyncTransactional;
	private String journalType;
	private Boolean logJournalWriteRate;
	private String jmxDomain;
	private Boolean jmxManagementEnabled;
	private String managementAddress;
	private String managementNotificationAddress;
	private Long messageExpiryScanPeriod;
	private Integer messageExpiryThreadPriority;
	private Boolean overrideInVmSecurity;
	private String securityDomain;
	private Boolean securityEnabled;
	private Long securityInvalidationInterval;
	private Integer messageCounterMaxDayHistory;
	private Long messageCounterSamplePeriod;
	private Boolean statisticsEnabled;
	private Long transactionTimeout;
	private Long transactionTimeoutScanPeriod;
	private ServerResources subresources = new ServerResources();
	private SharedStoreColocatedHaPolicy sharedStoreColocatedHaPolicy;
	private ReplicationMasterHaPolicy replicationMasterHaPolicy;
	private SharedStoreMasterHaPolicy sharedStoreMasterHaPolicy;
	private BindingsDirectoryPath bindingsDirectoryPath;
	private ReplicationColocatedHaPolicy replicationColocatedHaPolicy;
	private JournalDirectoryPath journalDirectoryPath;
	private SharedStoreSlaveHaPolicy sharedStoreSlaveHaPolicy;
	private PagingDirectoryPath pagingDirectoryPath;
	private LargeMessagesDirectoryPath largeMessagesDirectoryPath;
	private LiveOnlyHaPolicy liveOnlyHaPolicy;
	private ReplicationSlaveHaPolicy replicationSlaveHaPolicy;

	public Server(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).
	 */
	@SuppressWarnings("unchecked")
	public Server active(Boolean value) {
		this.active = value;
		return (Server) this;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.
	 */
	@ModelNodeBinding(detypedName = "async-connection-execution-enabled")
	public Boolean asyncConnectionExecutionEnabled() {
		return this.asyncConnectionExecutionEnabled;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.
	 */
	@SuppressWarnings("unchecked")
	public Server asyncConnectionExecutionEnabled(Boolean value) {
		this.asyncConnectionExecutionEnabled = value;
		return (Server) this;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive without receiving a ping.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl-override")
	public Long connectionTtlOverride() {
		return this.connectionTtlOverride;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive without receiving a ping.
	 */
	@SuppressWarnings("unchecked")
	public Server connectionTtlOverride(Long value) {
		this.connectionTtlOverride = value;
		return (Server) this;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@ModelNodeBinding(detypedName = "id-cache-size")
	public Integer idCacheSize() {
		return this.idCacheSize;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@SuppressWarnings("unchecked")
	public Server idCacheSize(Integer value) {
		this.idCacheSize = value;
		return (Server) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "incoming-interceptors")
	public List<Map> incomingInterceptors() {
		return this.incomingInterceptors;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public Server incomingInterceptors(List<java.util.Map> value) {
		this.incomingInterceptors = value;
		return (Server) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "outgoing-interceptors")
	public List<Map> outgoingInterceptors() {
		return this.outgoingInterceptors;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public Server outgoingInterceptors(List<java.util.Map> value) {
		this.outgoingInterceptors = value;
		return (Server) this;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@ModelNodeBinding(detypedName = "page-max-concurrent-io")
	public Integer pageMaxConcurrentIo() {
		return this.pageMaxConcurrentIo;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@SuppressWarnings("unchecked")
	public Server pageMaxConcurrentIo(Integer value) {
		this.pageMaxConcurrentIo = value;
		return (Server) this;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
	 */
	@ModelNodeBinding(detypedName = "persist-delivery-count-before-delivery")
	public Boolean persistDeliveryCountBeforeDelivery() {
		return this.persistDeliveryCountBeforeDelivery;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
	 */
	@SuppressWarnings("unchecked")
	public Server persistDeliveryCountBeforeDelivery(Boolean value) {
		this.persistDeliveryCountBeforeDelivery = value;
		return (Server) this;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@ModelNodeBinding(detypedName = "persist-id-cache")
	public Boolean persistIdCache() {
		return this.persistIdCache;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@SuppressWarnings("unchecked")
	public Server persistIdCache(Boolean value) {
		this.persistIdCache = value;
		return (Server) this;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@ModelNodeBinding(detypedName = "persistence-enabled")
	public Boolean persistenceEnabled() {
		return this.persistenceEnabled;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@SuppressWarnings("unchecked")
	public Server persistenceEnabled(Boolean value) {
		this.persistenceEnabled = value;
		return (Server) this;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@SuppressWarnings("unchecked")
	public Server scheduledThreadPoolMaxSize(Integer value) {
		this.scheduledThreadPoolMaxSize = value;
		return (Server) this;
	}

	/**
	 * Whether this server is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this server is started.
	 */
	@SuppressWarnings("unchecked")
	public Server started(Boolean value) {
		this.started = value;
		return (Server) this;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@SuppressWarnings("unchecked")
	public Server threadPoolMaxSize(Integer value) {
		this.threadPoolMaxSize = value;
		return (Server) this;
	}

	/**
	 * The server's version.
	 */
	@ModelNodeBinding(detypedName = "version")
	public String version() {
		return this.version;
	}

	/**
	 * The server's version.
	 */
	@SuppressWarnings("unchecked")
	public Server version(String value) {
		this.version = value;
		return (Server) this;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@ModelNodeBinding(detypedName = "wild-card-routing-enabled")
	public Boolean wildCardRoutingEnabled() {
		return this.wildCardRoutingEnabled;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@SuppressWarnings("unchecked")
	public Server wildCardRoutingEnabled(Boolean value) {
		this.wildCardRoutingEnabled = value;
		return (Server) this;
	}

	/**
	 * The password used by cluster connections to communicate between the clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-password")
	public String clusterPassword() {
		return this.clusterPassword;
	}

	/**
	 * The password used by cluster connections to communicate between the clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public Server clusterPassword(String value) {
		this.clusterPassword = value;
		return (Server) this;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-user")
	public String clusterUser() {
		return this.clusterUser;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public Server clusterUser(String value) {
		this.clusterUser = value;
		return (Server) this;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@ModelNodeBinding(detypedName = "memory-measure-interval")
	public Long memoryMeasureInterval() {
		return this.memoryMeasureInterval;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@SuppressWarnings("unchecked")
	public Server memoryMeasureInterval(Long value) {
		this.memoryMeasureInterval = value;
		return (Server) this;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@ModelNodeBinding(detypedName = "memory-warning-threshold")
	public Integer memoryWarningThreshold() {
		return this.memoryWarningThreshold;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@SuppressWarnings("unchecked")
	public Server memoryWarningThreshold(Integer value) {
		this.memoryWarningThreshold = value;
		return (Server) this;
	}

	/**
	 * TODO
	 */
	@ModelNodeBinding(detypedName = "perf-blast-pages")
	public Integer perfBlastPages() {
		return this.perfBlastPages;
	}

	/**
	 * TODO
	 */
	@SuppressWarnings("unchecked")
	public Server perfBlastPages(Integer value) {
		this.perfBlastPages = value;
		return (Server) this;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can sync. Useful when determining performance issues.
	 */
	@ModelNodeBinding(detypedName = "run-sync-speed-test")
	public Boolean runSyncSpeedTest() {
		return this.runSyncSpeedTest;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can sync. Useful when determining performance issues.
	 */
	@SuppressWarnings("unchecked")
	public Server runSyncSpeedTest(Boolean value) {
		this.runSyncSpeedTest = value;
		return (Server) this;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value less than 1 disables this feature.
	 */
	@ModelNodeBinding(detypedName = "server-dump-interval")
	public Long serverDumpInterval() {
		return this.serverDumpInterval;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value less than 1 disables this feature.
	 */
	@SuppressWarnings("unchecked")
	public Server serverDumpInterval(Long value) {
		this.serverDumpInterval = value;
		return (Server) this;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-bindings-dir")
	public Boolean createBindingsDir() {
		return this.createBindingsDir;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public Server createBindingsDir(Boolean value) {
		this.createBindingsDir = value;
		return (Server) this;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-journal-dir")
	public Boolean createJournalDir() {
		return this.createJournalDir;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public Server createJournalDir(Boolean value) {
		this.createJournalDir = value;
		return (Server) this;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-size")
	public Long journalBufferSize() {
		return this.journalBufferSize;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@SuppressWarnings("unchecked")
	public Server journalBufferSize(Long value) {
		this.journalBufferSize = value;
		return (Server) this;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-timeout")
	public Long journalBufferTimeout() {
		return this.journalBufferTimeout;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the journal.
	 */
	@SuppressWarnings("unchecked")
	public Server journalBufferTimeout(Long value) {
		this.journalBufferTimeout = value;
		return (Server) this;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-min-files")
	public Integer journalCompactMinFiles() {
		return this.journalCompactMinFiles;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@SuppressWarnings("unchecked")
	public Server journalCompactMinFiles(Integer value) {
		this.journalCompactMinFiles = value;
		return (Server) this;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-percentage")
	public Integer journalCompactPercentage() {
		return this.journalCompactPercentage;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@SuppressWarnings("unchecked")
	public Server journalCompactPercentage(Integer value) {
		this.journalCompactPercentage = value;
		return (Server) this;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@ModelNodeBinding(detypedName = "journal-file-size")
	public Long journalFileSize() {
		return this.journalFileSize;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@SuppressWarnings("unchecked")
	public Server journalFileSize(Long value) {
		this.journalFileSize = value;
		return (Server) this;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any one time.
	 */
	@ModelNodeBinding(detypedName = "journal-max-io")
	public Integer journalMaxIo() {
		return this.journalMaxIo;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any one time.
	 */
	@SuppressWarnings("unchecked")
	public Server journalMaxIo(Integer value) {
		this.journalMaxIo = value;
		return (Server) this;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@ModelNodeBinding(detypedName = "journal-min-files")
	public Integer journalMinFiles() {
		return this.journalMinFiles;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@SuppressWarnings("unchecked")
	public Server journalMinFiles(Integer value) {
		this.journalMinFiles = value;
		return (Server) this;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-non-transactional")
	public Boolean journalSyncNonTransactional() {
		return this.journalSyncNonTransactional;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public Server journalSyncNonTransactional(Boolean value) {
		this.journalSyncNonTransactional = value;
		return (Server) this;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-transactional")
	public Boolean journalSyncTransactional() {
		return this.journalSyncTransactional;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public Server journalSyncTransactional(Boolean value) {
		this.journalSyncTransactional = value;
		return (Server) this;
	}

	/**
	 * The type of journal to use.
	 */
	@ModelNodeBinding(detypedName = "journal-type")
	public String journalType() {
		return this.journalType;
	}

	/**
	 * The type of journal to use.
	 */
	@SuppressWarnings("unchecked")
	public Server journalType(String value) {
		this.journalType = value;
		return (Server) this;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@ModelNodeBinding(detypedName = "log-journal-write-rate")
	public Boolean logJournalWriteRate() {
		return this.logJournalWriteRate;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@SuppressWarnings("unchecked")
	public Server logJournalWriteRate(Boolean value) {
		this.logJournalWriteRate = value;
		return (Server) this;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.
	 */
	@ModelNodeBinding(detypedName = "jmx-domain")
	public String jmxDomain() {
		return this.jmxDomain;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.
	 */
	@SuppressWarnings("unchecked")
	public Server jmxDomain(String value) {
		this.jmxDomain = value;
		return (Server) this;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.
	 */
	@ModelNodeBinding(detypedName = "jmx-management-enabled")
	public Boolean jmxManagementEnabled() {
		return this.jmxManagementEnabled;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.
	 */
	@SuppressWarnings("unchecked")
	public Server jmxManagementEnabled(Boolean value) {
		this.jmxManagementEnabled = value;
		return (Server) this;
	}

	/**
	 * Address to send management messages to.
	 */
	@ModelNodeBinding(detypedName = "management-address")
	public String managementAddress() {
		return this.managementAddress;
	}

	/**
	 * Address to send management messages to.
	 */
	@SuppressWarnings("unchecked")
	public Server managementAddress(String value) {
		this.managementAddress = value;
		return (Server) this;
	}

	/**
	 * The name of the address that consumers bind to  to receive management notifications.
	 */
	@ModelNodeBinding(detypedName = "management-notification-address")
	public String managementNotificationAddress() {
		return this.managementNotificationAddress;
	}

	/**
	 * The name of the address that consumers bind to  to receive management notifications.
	 */
	@SuppressWarnings("unchecked")
	public Server managementNotificationAddress(String value) {
		this.managementNotificationAddress = value;
		return (Server) this;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-scan-period")
	public Long messageExpiryScanPeriod() {
		return this.messageExpiryScanPeriod;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@SuppressWarnings("unchecked")
	public Server messageExpiryScanPeriod(Long value) {
		this.messageExpiryScanPeriod = value;
		return (Server) this;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-thread-priority")
	public Integer messageExpiryThreadPriority() {
		return this.messageExpiryThreadPriority;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@SuppressWarnings("unchecked")
	public Server messageExpiryThreadPriority(Integer value) {
		this.messageExpiryThreadPriority = value;
		return (Server) this;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm connections.
	 */
	@ModelNodeBinding(detypedName = "override-in-vm-security")
	public Boolean overrideInVmSecurity() {
		return this.overrideInVmSecurity;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm connections.
	 */
	@SuppressWarnings("unchecked")
	public Server overrideInVmSecurity(Boolean value) {
		this.overrideInVmSecurity = value;
		return (Server) this;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@SuppressWarnings("unchecked")
	public Server securityDomain(String value) {
		this.securityDomain = value;
		return (Server) this;
	}

	/**
	 * Whether security is enabled.
	 */
	@ModelNodeBinding(detypedName = "security-enabled")
	public Boolean securityEnabled() {
		return this.securityEnabled;
	}

	/**
	 * Whether security is enabled.
	 */
	@SuppressWarnings("unchecked")
	public Server securityEnabled(Boolean value) {
		this.securityEnabled = value;
		return (Server) this;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@ModelNodeBinding(detypedName = "security-invalidation-interval")
	public Long securityInvalidationInterval() {
		return this.securityInvalidationInterval;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@SuppressWarnings("unchecked")
	public Server securityInvalidationInterval(Long value) {
		this.securityInvalidationInterval = value;
		return (Server) this;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@ModelNodeBinding(detypedName = "message-counter-max-day-history")
	public Integer messageCounterMaxDayHistory() {
		return this.messageCounterMaxDayHistory;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@SuppressWarnings("unchecked")
	public Server messageCounterMaxDayHistory(Integer value) {
		this.messageCounterMaxDayHistory = value;
		return (Server) this;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@ModelNodeBinding(detypedName = "message-counter-sample-period")
	public Long messageCounterSamplePeriod() {
		return this.messageCounterSamplePeriod;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@SuppressWarnings("unchecked")
	public Server messageCounterSamplePeriod(Long value) {
		this.messageCounterSamplePeriod = value;
		return (Server) this;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@SuppressWarnings("unchecked")
	public Server statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (Server) this;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource manager after create time.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout")
	public Long transactionTimeout() {
		return this.transactionTimeout;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource manager after create time.
	 */
	@SuppressWarnings("unchecked")
	public Server transactionTimeout(Long value) {
		this.transactionTimeout = value;
		return (Server) this;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout-scan-period")
	public Long transactionTimeoutScanPeriod() {
		return this.transactionTimeoutScanPeriod;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@SuppressWarnings("unchecked")
	public Server transactionTimeoutScanPeriod(Long value) {
		this.transactionTimeoutScanPeriod = value;
		return (Server) this;
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.ConnectorService objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.ConnectorService objects.
	 */
	@SuppressWarnings("unchecked")
	public Server connectorServices(
			List<org.wildfly.swarm.config.messaging_activemq.server.ConnectorService> value) {
		this.subresources.connectorServices.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.ConnectorService object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.ConnectorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server connectorService(ConnectorService value) {
		this.subresources.connectorServices.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public Server httpAcceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor> value) {
		this.subresources.httpAcceptors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpAcceptor(HttpAcceptor value) {
		this.subresources.httpAcceptors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public Server clusterConnections(
			List<org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection> value) {
		this.subresources.clusterConnections.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server clusterConnection(ClusterConnection value) {
		this.subresources.clusterConnections.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public Server broadcastGroups(
			List<org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup> value) {
		this.subresources.broadcastGroups.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server broadcastGroup(BroadcastGroup value) {
		this.subresources.broadcastGroups.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public Server runtimeQueues(
			List<org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue> value) {
		this.subresources.runtimeQueues.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server runtimeQueue(RuntimeQueue value) {
		this.subresources.runtimeQueues.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.AddressSetting objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.AddressSetting objects.
	 */
	@SuppressWarnings("unchecked")
	public Server addressSettings(
			List<org.wildfly.swarm.config.messaging_activemq.server.AddressSetting> value) {
		this.subresources.addressSettings.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.AddressSetting object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.AddressSetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server addressSetting(AddressSetting value) {
		this.subresources.addressSettings.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.JmsQueue objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.JmsQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public Server jmsQueues(
			List<org.wildfly.swarm.config.messaging_activemq.server.JmsQueue> value) {
		this.subresources.jmsQueues.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.JmsQueue object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.JmsQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server jmsQueue(JmsQueue value) {
		this.subresources.jmsQueues.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public Server pooledConnectionFactorys(
			List<org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory> value) {
		this.subresources.pooledConnectionFactorys.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server pooledConnectionFactory(PooledConnectionFactory value) {
		this.subresources.pooledConnectionFactorys.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Divert objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Divert objects.
	 */
	@SuppressWarnings("unchecked")
	public Server diverts(
			List<org.wildfly.swarm.config.messaging_activemq.server.Divert> value) {
		this.subresources.diverts.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Divert object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Divert to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server divert(Divert value) {
		this.subresources.diverts.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public Server inVmAcceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor> value) {
		this.subresources.inVmAcceptors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server inVmAcceptor(InVmAcceptor value) {
		this.subresources.inVmAcceptors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public Server discoveryGroups(
			List<org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup> value) {
		this.subresources.discoveryGroups.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server discoveryGroup(DiscoveryGroup value) {
		this.subresources.discoveryGroups.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.HttpConnector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.HttpConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public Server httpConnectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.HttpConnector> value) {
		this.subresources.httpConnectors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.HttpConnector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.HttpConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server httpConnector(HttpConnector value) {
		this.subresources.httpConnectors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public Server connectionFactorys(
			List<org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory> value) {
		this.subresources.connectionFactorys.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server connectionFactory(ConnectionFactory value) {
		this.subresources.connectionFactorys.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Acceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Acceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public Server acceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.Acceptor> value) {
		this.subresources.acceptors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Acceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Acceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server acceptor(Acceptor value) {
		this.subresources.acceptors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public Server remoteAcceptors(
			List<org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor> value) {
		this.subresources.remoteAcceptors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server remoteAcceptor(RemoteAcceptor value) {
		this.subresources.remoteAcceptors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public Server remoteConnectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector> value) {
		this.subresources.remoteConnectors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server remoteConnector(RemoteConnector value) {
		this.subresources.remoteConnectors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.InVmConnector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.InVmConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public Server inVmConnectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.InVmConnector> value) {
		this.subresources.inVmConnectors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.InVmConnector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.InVmConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server inVmConnector(InVmConnector value) {
		this.subresources.inVmConnectors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public Server legacyConnectionFactorys(
			List<org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory> value) {
		this.subresources.legacyConnectionFactorys.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server legacyConnectionFactory(LegacyConnectionFactory value) {
		this.subresources.legacyConnectionFactorys.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public Server groupingHandlers(
			List<org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler> value) {
		this.subresources.groupingHandlers.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server groupingHandler(GroupingHandler value) {
		this.subresources.groupingHandlers.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.JmsTopic objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.JmsTopic objects.
	 */
	@SuppressWarnings("unchecked")
	public Server jmsTopics(
			List<org.wildfly.swarm.config.messaging_activemq.server.JmsTopic> value) {
		this.subresources.jmsTopics.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.JmsTopic object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.JmsTopic to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server jmsTopic(JmsTopic value) {
		this.subresources.jmsTopics.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Connector objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public Server connectors(
			List<org.wildfly.swarm.config.messaging_activemq.server.Connector> value) {
		this.subresources.connectors.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Connector object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server connector(Connector value) {
		this.subresources.connectors.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting objects.
	 */
	@SuppressWarnings("unchecked")
	public Server securitySettings(
			List<org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting> value) {
		this.subresources.securitySettings.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server securitySetting(SecuritySetting value) {
		this.subresources.securitySettings.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.CoreAddress objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.CoreAddress objects.
	 */
	@SuppressWarnings("unchecked")
	public Server coreAddress(
			List<org.wildfly.swarm.config.messaging_activemq.server.CoreAddress> value) {
		this.subresources.coreAddress.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.CoreAddress object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.CoreAddress to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server coreAddress(CoreAddress value) {
		this.subresources.coreAddress.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Bridge objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Bridge objects.
	 */
	@SuppressWarnings("unchecked")
	public Server bridges(
			List<org.wildfly.swarm.config.messaging_activemq.server.Bridge> value) {
		this.subresources.bridges.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Bridge object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Bridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server bridge(Bridge value) {
		this.subresources.bridges.add(value);
		return (Server) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Queue objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Queue objects.
	 */
	@SuppressWarnings("unchecked")
	public Server queues(
			List<org.wildfly.swarm.config.messaging_activemq.server.Queue> value) {
		this.subresources.queues.addAll(value);
		return (Server) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Queue object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Queue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Server queue(Queue value) {
		this.subresources.queues.add(value);
		return (Server) this;
	}

	/**
	 * Child mutators for Server
	 */
	public class ServerResources {
		/**
		 * TODO
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.ConnectorService> connectorServices = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ server over HTTP.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor> httpAcceptors = new java.util.ArrayList<>();
		/**
		 * Cluster connections group servers into clusters so that messages can be load balanced between the nodes of the cluster.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection> clusterConnections = new java.util.ArrayList<>();
		/**
		 * A broadcast group is the means by which a server broadcasts connectors over the network.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup> broadcastGroups = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue> runtimeQueues = new java.util.ArrayList<>();
		/**
		 * An address setting defines some attributes that are defined against an address wildcard rather than a specific queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.AddressSetting> addressSettings = new java.util.ArrayList<>();
		/**
		 * Defines a JMS queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.JmsQueue> jmsQueues = new java.util.ArrayList<>();
		/**
		 * Defines a managed connection factory.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory> pooledConnectionFactorys = new java.util.ArrayList<>();
		/**
		 * A messaging resource that allows you to transparently divert messages routed to one address to some other address, without making any changes to any client application logic.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Divert> diverts = new java.util.ArrayList<>();
		/**
		 * Defines a way in which in-VM connections can be made to the ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor> inVmAcceptors = new java.util.ArrayList<>();
		/**
		 * Multicast group to listen to receive broadcast from other servers announcing their connectors.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup> discoveryGroups = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server over HTTP.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.HttpConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory> connectionFactorys = new java.util.ArrayList<>();
		/**
		 * An acceptor defines a way in which connections can be made to the ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Acceptor> acceptors = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor> remoteAcceptors = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector> remoteConnectors = new java.util.ArrayList<>();
		/**
		 * Used by an in-VM client to define how it connects to a server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.InVmConnector> inVmConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory> legacyConnectionFactorys = new java.util.ArrayList<>();
		/**
		 * Makes decisions about which node in a cluster should handle a message with a group id assigned.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler> groupingHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a JMS topic.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.JmsTopic> jmsTopics = new java.util.ArrayList<>();
		/**
		 * A connector can be used by a client to define how it connects to a server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Connector> connectors = new java.util.ArrayList<>();
		/**
		 * A security setting allows sets of permissions to be defined against queues based on their address.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting> securitySettings = new java.util.ArrayList<>();
		/**
		 * A runtime-only resource representing a ActiveMQ "address". Zero or more queues can be bound to a single address. When a message is routed, it is routed to the set of queues bound to the message's address.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.CoreAddress> coreAddress = new java.util.ArrayList<>();
		/**
		 * The function of a bridge is to consume messages from a source queue, and forward them to a target address, typically on a different ActiveMQ server.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Bridge> bridges = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Queue> queues = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.ConnectorService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectorService> connectorServices() {
			return this.connectorServices;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.HttpAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpAcceptor> httpAcceptors() {
			return this.httpAcceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.ClusterConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ClusterConnection> clusterConnections() {
			return this.clusterConnections;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BroadcastGroup> broadcastGroups() {
			return this.broadcastGroups;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.RuntimeQueue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RuntimeQueue> runtimeQueues() {
			return this.runtimeQueues;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.AddressSetting resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AddressSetting> addressSettings() {
			return this.addressSettings;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.JmsQueue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JmsQueue> jmsQueues() {
			return this.jmsQueues;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.PooledConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PooledConnectionFactory> pooledConnectionFactorys() {
			return this.pooledConnectionFactorys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Divert resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Divert> diverts() {
			return this.diverts;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.InVmAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<InVmAcceptor> inVmAcceptors() {
			return this.inVmAcceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DiscoveryGroup> discoveryGroups() {
			return this.discoveryGroups;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.HttpConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpConnector> httpConnectors() {
			return this.httpConnectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.ConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionFactory> connectionFactorys() {
			return this.connectionFactorys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Acceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Acceptor> acceptors() {
			return this.acceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.RemoteAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteAcceptor> remoteAcceptors() {
			return this.remoteAcceptors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.RemoteConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteConnector> remoteConnectors() {
			return this.remoteConnectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.InVmConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<InVmConnector> inVmConnectors() {
			return this.inVmConnectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.LegacyConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LegacyConnectionFactory> legacyConnectionFactorys() {
			return this.legacyConnectionFactorys;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.GroupingHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<GroupingHandler> groupingHandlers() {
			return this.groupingHandlers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.JmsTopic resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JmsTopic> jmsTopics() {
			return this.jmsTopics;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Connector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.SecuritySetting resources
		 * @return the list of resources
		 */
		@Subresource
		public List<SecuritySetting> securitySettings() {
			return this.securitySettings;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.CoreAddress resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CoreAddress> coreAddress() {
			return this.coreAddress;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Bridge resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Bridge> bridges() {
			return this.bridges;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Queue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Queue> queues() {
			return this.queues;
		}
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SharedStoreColocatedHaPolicy sharedStoreColocatedHaPolicy() {
		return this.sharedStoreColocatedHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public Server sharedStoreColocatedHaPolicy(
			SharedStoreColocatedHaPolicy value) {
		this.sharedStoreColocatedHaPolicy = value;
		return (Server) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ReplicationMasterHaPolicy replicationMasterHaPolicy() {
		return this.replicationMasterHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public Server replicationMasterHaPolicy(ReplicationMasterHaPolicy value) {
		this.replicationMasterHaPolicy = value;
		return (Server) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SharedStoreMasterHaPolicy sharedStoreMasterHaPolicy() {
		return this.sharedStoreMasterHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public Server sharedStoreMasterHaPolicy(SharedStoreMasterHaPolicy value) {
		this.sharedStoreMasterHaPolicy = value;
		return (Server) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public BindingsDirectoryPath bindingsDirectoryPath() {
		return this.bindingsDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public Server bindingsDirectoryPath(BindingsDirectoryPath value) {
		this.bindingsDirectoryPath = value;
		return (Server) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ReplicationColocatedHaPolicy replicationColocatedHaPolicy() {
		return this.replicationColocatedHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public Server replicationColocatedHaPolicy(
			ReplicationColocatedHaPolicy value) {
		this.replicationColocatedHaPolicy = value;
		return (Server) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public JournalDirectoryPath journalDirectoryPath() {
		return this.journalDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public Server journalDirectoryPath(JournalDirectoryPath value) {
		this.journalDirectoryPath = value;
		return (Server) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SharedStoreSlaveHaPolicy sharedStoreSlaveHaPolicy() {
		return this.sharedStoreSlaveHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public Server sharedStoreSlaveHaPolicy(SharedStoreSlaveHaPolicy value) {
		this.sharedStoreSlaveHaPolicy = value;
		return (Server) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public PagingDirectoryPath pagingDirectoryPath() {
		return this.pagingDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public Server pagingDirectoryPath(PagingDirectoryPath value) {
		this.pagingDirectoryPath = value;
		return (Server) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public LargeMessagesDirectoryPath largeMessagesDirectoryPath() {
		return this.largeMessagesDirectoryPath;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public Server largeMessagesDirectoryPath(LargeMessagesDirectoryPath value) {
		this.largeMessagesDirectoryPath = value;
		return (Server) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public LiveOnlyHaPolicy liveOnlyHaPolicy() {
		return this.liveOnlyHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public Server liveOnlyHaPolicy(LiveOnlyHaPolicy value) {
		this.liveOnlyHaPolicy = value;
		return (Server) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ReplicationSlaveHaPolicy replicationSlaveHaPolicy() {
		return this.replicationSlaveHaPolicy;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public Server replicationSlaveHaPolicy(ReplicationSlaveHaPolicy value) {
		this.replicationSlaveHaPolicy = value;
		return (Server) this;
	}
}