package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("ha-policy")
@Implicit
public class ReplicationMasterHaPolicy {

	private String key;
	private Boolean checkForLiveServer;
	private String clusterName;
	private String groupName;

	public ReplicationMasterHaPolicy() {
		this.key = "replication-master";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether to check the cluster for another server using the same server ID when starting up.
	 */
	@ModelNodeBinding(detypedName = "check-for-live-server")
	public Boolean checkForLiveServer() {
		return this.checkForLiveServer;
	}

	/**
	 * Whether to check the cluster for another server using the same server ID when starting up.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationMasterHaPolicy checkForLiveServer(Boolean value) {
		this.checkForLiveServer = value;
		return (ReplicationMasterHaPolicy) this;
	}

	/**
	 * Name of the cluster used for replication.
	 */
	@ModelNodeBinding(detypedName = "cluster-name")
	public String clusterName() {
		return this.clusterName;
	}

	/**
	 * Name of the cluster used for replication.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationMasterHaPolicy clusterName(String value) {
		this.clusterName = value;
		return (ReplicationMasterHaPolicy) this;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching group-name.
	 */
	@ModelNodeBinding(detypedName = "group-name")
	public String groupName() {
		return this.groupName;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching group-name.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationMasterHaPolicy groupName(String value) {
		this.groupName = value;
		return (ReplicationMasterHaPolicy) this;
	}
}