package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
/**
 * A security setting allows sets of permissions to be defined against queues based on their address.
 */
@ResourceType("security-setting")
public class SecuritySetting {

	private String key;
	private SecuritySettingResources subresources = new SecuritySettingResources();

	public SecuritySetting(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	public SecuritySettingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.messaging_activemq.server.Role objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.messaging_activemq.server.Role objects.
	 */
	@SuppressWarnings("unchecked")
	public SecuritySetting roles(
			List<org.wildfly.swarm.config.messaging_activemq.server.Role> value) {
		this.subresources.roles.addAll(value);
		return (SecuritySetting) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.messaging_activemq.server.Role object to the list of subresources
	 * @param value The org.wildfly.swarm.config.messaging_activemq.server.Role to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public SecuritySetting role(Role value) {
		this.subresources.roles.add(value);
		return (SecuritySetting) this;
	}

	/**
	 * Child mutators for SecuritySetting
	 */
	public class SecuritySettingResources {
		/**
		 * A security role.
		 */
		private List<org.wildfly.swarm.config.messaging_activemq.server.Role> roles = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.messaging_activemq.server.Role resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Role> roles() {
			return this.roles;
		}
	}
}