package org.wildfly.swarm.config.remoting;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
/**
 * The configuration of a Remoting connector.
 */
@ResourceType("connector")
public class Connector {

	private String key;
	private String authenticationProvider;
	private String saslProtocol;
	private String securityRealm;
	private String serverName;
	private String socketBinding;
	private ConnectorResources subresources = new ConnectorResources();
	private SaslSecurity saslSecurity;

	public Connector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The "authentication-provider" element contains the name of the authentication provider to use for incoming connections.
	 */
	@ModelNodeBinding(detypedName = "authentication-provider")
	public String authenticationProvider() {
		return this.authenticationProvider;
	}

	/**
	 * The "authentication-provider" element contains the name of the authentication provider to use for incoming connections.
	 */
	@SuppressWarnings("unchecked")
	public Connector authenticationProvider(String value) {
		this.authenticationProvider = value;
		return (Connector) this;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * The protocol to pass into the SASL mechanisms used for authentication.
	 */
	@SuppressWarnings("unchecked")
	public Connector saslProtocol(String value) {
		this.saslProtocol = value;
		return (Connector) this;
	}

	/**
	 * The associated security realm to use for authentication for this connector.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The associated security realm to use for authentication for this connector.
	 */
	@SuppressWarnings("unchecked")
	public Connector securityRealm(String value) {
		this.securityRealm = value;
		return (Connector) this;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL based authentication.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server name to send in the initial message exchange and for SASL based authentication.
	 */
	@SuppressWarnings("unchecked")
	public Connector serverName(String value) {
		this.serverName = value;
		return (Connector) this;
	}

	/**
	 * The name (or names) of the socket binding(s) to attach to.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The name (or names) of the socket binding(s) to attach to.
	 */
	@SuppressWarnings("unchecked")
	public Connector socketBinding(String value) {
		this.socketBinding = value;
		return (Connector) this;
	}

	public ConnectorResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.Property objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.Property objects.
	 */
	@SuppressWarnings("unchecked")
	public Connector propertys(
			List<org.wildfly.swarm.config.remoting.Property> value) {
		this.subresources.propertys.addAll(value);
		return (Connector) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Connector property(Property value) {
		this.subresources.propertys.add(value);
		return (Connector) this;
	}

	/**
	 * Child mutators for Connector
	 */
	public class ConnectorResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<org.wildfly.swarm.config.remoting.Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for this connector.
	 */
	@Subresource
	public SaslSecurity saslSecurity() {
		return this.saslSecurity;
	}

	/**
	 * The "sasl" element contains the SASL authentication configuration for this connector.
	 */
	@SuppressWarnings("unchecked")
	public Connector saslSecurity(SaslSecurity value) {
		this.saslSecurity = value;
		return (Connector) this;
	}
}