package org.wildfly.swarm.config.remoting;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
/**
 * Remoting outbound connection.
 */
@ResourceType("outbound-connection")
public class OutboundConnection {

	private String key;
	private String uri;
	private OutboundConnectionResources subresources = new OutboundConnectionResources();

	public OutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The connection URI for the outbound connection.
	 */
	@ModelNodeBinding(detypedName = "uri")
	public String uri() {
		return this.uri;
	}

	/**
	 * The connection URI for the outbound connection.
	 */
	@SuppressWarnings("unchecked")
	public OutboundConnection uri(String value) {
		this.uri = value;
		return (OutboundConnection) this;
	}

	public OutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.Property objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.Property objects.
	 */
	@SuppressWarnings("unchecked")
	public OutboundConnection propertys(
			List<org.wildfly.swarm.config.remoting.Property> value) {
		this.subresources.propertys.addAll(value);
		return (OutboundConnection) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public OutboundConnection property(Property value) {
		this.subresources.propertys.add(value);
		return (OutboundConnection) this;
	}

	/**
	 * Child mutators for OutboundConnection
	 */
	public class OutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<org.wildfly.swarm.config.remoting.Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}