package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule;
/**
 * Authorization configuration. Configures a list of authorization policy modules to be used.
 */
@ResourceType("authorization")
@Implicit
public class ClassicAuthorization {

	private String key;
	private ClassicAuthorizationResources subresources = new ClassicAuthorizationResources();

	public ClassicAuthorization() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicAuthorizationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthorization policyModules(
			List<org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule> value) {
		this.subresources.policyModules.addAll(value);
		return (ClassicAuthorization) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthorization policyModule(PolicyModule value) {
		this.subresources.policyModules.add(value);
		return (ClassicAuthorization) this;
	}

	/**
	 * Child mutators for ClassicAuthorization
	 */
	public class ClassicAuthorizationResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule> policyModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PolicyModule> policyModules() {
			return this.policyModules;
		}
	}
}