package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModule;
/**
 * JASPI authentication configuration.
 */
@ResourceType("authentication")
@Implicit
public class JaspiAuthentication {

	private String key;
	private JaspiAuthenticationResources subresources = new JaspiAuthenticationResources();

	public JaspiAuthentication() {
		this.key = "jaspi";
	}

	public String getKey() {
		return this.key;
	}

	public JaspiAuthenticationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack objects.
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication loginModuleStacks(
			List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack> value) {
		this.subresources.loginModuleStacks.addAll(value);
		return (JaspiAuthentication) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication loginModuleStack(LoginModuleStack value) {
		this.subresources.loginModuleStacks.add(value);
		return (JaspiAuthentication) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authentication.AuthModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authentication.AuthModule objects.
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication authModules(
			List<org.wildfly.swarm.config.security.security_domain.authentication.AuthModule> value) {
		this.subresources.authModules.addAll(value);
		return (JaspiAuthentication) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authentication.AuthModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authentication.AuthModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public JaspiAuthentication authModule(AuthModule value) {
		this.subresources.authModules.add(value);
		return (JaspiAuthentication) this;
	}

	/**
	 * Child mutators for JaspiAuthentication
	 */
	public class JaspiAuthenticationResources {
		/**
		 * List of "named" login modules that are used by jaspi authentication modules.
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack> loginModuleStacks = new java.util.ArrayList<>();
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authentication.AuthModule> authModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModuleStack> loginModuleStacks() {
			return this.loginModuleStacks;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authentication.AuthModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AuthModule> authModules() {
			return this.authModules;
		}
	}
}