package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The error pages
 */
@ResourceType("error-page")
public class ErrorPage {

	private String key;
	private Integer code;
	private String path;

	public ErrorPage(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Error page code
	 */
	@ModelNodeBinding(detypedName = "code")
	public Integer code() {
		return this.code;
	}

	/**
	 * Error page code
	 */
	@SuppressWarnings("unchecked")
	public ErrorPage code(Integer value) {
		this.code = value;
		return (ErrorPage) this;
	}

	/**
	 * Error page path
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Error page path
	 */
	@SuppressWarnings("unchecked")
	public ErrorPage path(String value) {
		this.path = value;
		return (ErrorPage) this;
	}
}