package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A rewrite (or redirect) filter
 */
@ResourceType("rewrite")
public class Rewrite {

	private String key;
	private Boolean redirect;
	private String target;

	public Rewrite(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If this is true then a redirect will be done instead of a rewrite
	 */
	@ModelNodeBinding(detypedName = "redirect")
	public Boolean redirect() {
		return this.redirect;
	}

	/**
	 * If this is true then a redirect will be done instead of a rewrite
	 */
	@SuppressWarnings("unchecked")
	public Rewrite redirect(Boolean value) {
		this.redirect = value;
		return (Rewrite) this;
	}

	/**
	 * The expression that defines the target. If you are redirecting to a constant target put single quotes around the value
	 */
	@ModelNodeBinding(detypedName = "target")
	public String target() {
		return this.target;
	}

	/**
	 * The expression that defines the target. If you are redirecting to a constant target put single quotes around the value
	 */
	@SuppressWarnings("unchecked")
	public Rewrite target(String value) {
		this.target = value;
		return (Rewrite) this;
	}
}