package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context;
/**
 * Runtime representation of a mod_cluster node
 */
@ResourceType("node")
public class Node {

	private String key;
	private List<String> aliases;
	private Integer cacheConnections;
	private Integer elected;
	private Boolean flushPackets;
	private Integer load;
	private String loadBalancingGroup;
	private Integer maxConnections;
	private Integer openConnections;
	private Integer ping;
	private Boolean queueNewRequests;
	private Long read;
	private Integer requestQueueSize;
	private String status;
	private Integer timeout;
	private Long ttl;
	private String uri;
	private Long written;
	private NodeResources subresources = new NodeResources();

	public Node(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The nodes aliases
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The nodes aliases
	 */
	@SuppressWarnings("unchecked")
	public Node aliases(List<String> value) {
		this.aliases = value;
		return (Node) this;
	}

	/**
	 * The number of connections to keep alive indefinitely
	 */
	@ModelNodeBinding(detypedName = "cache-connections")
	public Integer cacheConnections() {
		return this.cacheConnections;
	}

	/**
	 * The number of connections to keep alive indefinitely
	 */
	@SuppressWarnings("unchecked")
	public Node cacheConnections(Integer value) {
		this.cacheConnections = value;
		return (Node) this;
	}

	/**
	 * The elected count
	 */
	@ModelNodeBinding(detypedName = "elected")
	public Integer elected() {
		return this.elected;
	}

	/**
	 * The elected count
	 */
	@SuppressWarnings("unchecked")
	public Node elected(Integer value) {
		this.elected = value;
		return (Node) this;
	}

	/**
	 * If received data should be immediately flushed
	 */
	@ModelNodeBinding(detypedName = "flush-packets")
	public Boolean flushPackets() {
		return this.flushPackets;
	}

	/**
	 * If received data should be immediately flushed
	 */
	@SuppressWarnings("unchecked")
	public Node flushPackets(Boolean value) {
		this.flushPackets = value;
		return (Node) this;
	}

	/**
	 * The current load of this node
	 */
	@ModelNodeBinding(detypedName = "load")
	public Integer load() {
		return this.load;
	}

	/**
	 * The current load of this node
	 */
	@SuppressWarnings("unchecked")
	public Node load(Integer value) {
		this.load = value;
		return (Node) this;
	}

	/**
	 * The load balancing group this node belongs to
	 */
	@ModelNodeBinding(detypedName = "load-balancing-group")
	public String loadBalancingGroup() {
		return this.loadBalancingGroup;
	}

	/**
	 * The load balancing group this node belongs to
	 */
	@SuppressWarnings("unchecked")
	public Node loadBalancingGroup(String value) {
		this.loadBalancingGroup = value;
		return (Node) this;
	}

	/**
	 * The maximum number of connections per IO thread
	 */
	@ModelNodeBinding(detypedName = "max-connections")
	public Integer maxConnections() {
		return this.maxConnections;
	}

	/**
	 * The maximum number of connections per IO thread
	 */
	@SuppressWarnings("unchecked")
	public Node maxConnections(Integer value) {
		this.maxConnections = value;
		return (Node) this;
	}

	/**
	 * The current number of open connections
	 */
	@ModelNodeBinding(detypedName = "open-connections")
	public Integer openConnections() {
		return this.openConnections;
	}

	/**
	 * The current number of open connections
	 */
	@SuppressWarnings("unchecked")
	public Node openConnections(Integer value) {
		this.openConnections = value;
		return (Node) this;
	}

	/**
	 * The nodes ping
	 */
	@ModelNodeBinding(detypedName = "ping")
	public Integer ping() {
		return this.ping;
	}

	/**
	 * The nodes ping
	 */
	@SuppressWarnings("unchecked")
	public Node ping(Integer value) {
		this.ping = value;
		return (Node) this;
	}

	/**
	 * If a request is received and there is no worker immediately available should it be queued
	 */
	@ModelNodeBinding(detypedName = "queue-new-requests")
	public Boolean queueNewRequests() {
		return this.queueNewRequests;
	}

	/**
	 * If a request is received and there is no worker immediately available should it be queued
	 */
	@SuppressWarnings("unchecked")
	public Node queueNewRequests(Boolean value) {
		this.queueNewRequests = value;
		return (Node) this;
	}

	/**
	 * The number of bytes read from the node
	 */
	@ModelNodeBinding(detypedName = "read")
	public Long read() {
		return this.read;
	}

	/**
	 * The number of bytes read from the node
	 */
	@SuppressWarnings("unchecked")
	public Node read(Long value) {
		this.read = value;
		return (Node) this;
	}

	/**
	 * The size of the request queue
	 */
	@ModelNodeBinding(detypedName = "request-queue-size")
	public Integer requestQueueSize() {
		return this.requestQueueSize;
	}

	/**
	 * The size of the request queue
	 */
	@SuppressWarnings("unchecked")
	public Node requestQueueSize(Integer value) {
		this.requestQueueSize = value;
		return (Node) this;
	}

	/**
	 * The current status of this node
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * The current status of this node
	 */
	@SuppressWarnings("unchecked")
	public Node status(String value) {
		this.status = value;
		return (Node) this;
	}

	/**
	 * The request timeout
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Integer timeout() {
		return this.timeout;
	}

	/**
	 * The request timeout
	 */
	@SuppressWarnings("unchecked")
	public Node timeout(Integer value) {
		this.timeout = value;
		return (Node) this;
	}

	/**
	 * The time connections will stay alive with no requests before being closed, if the number of connections is larger than cache-connections
	 */
	@ModelNodeBinding(detypedName = "ttl")
	public Long ttl() {
		return this.ttl;
	}

	/**
	 * The time connections will stay alive with no requests before being closed, if the number of connections is larger than cache-connections
	 */
	@SuppressWarnings("unchecked")
	public Node ttl(Long value) {
		this.ttl = value;
		return (Node) this;
	}

	/**
	 * The URI that the load balancer uses to connect to the node
	 */
	@ModelNodeBinding(detypedName = "uri")
	public String uri() {
		return this.uri;
	}

	/**
	 * The URI that the load balancer uses to connect to the node
	 */
	@SuppressWarnings("unchecked")
	public Node uri(String value) {
		this.uri = value;
		return (Node) this;
	}

	/**
	 * The number of bytes transferred to the node
	 */
	@ModelNodeBinding(detypedName = "written")
	public Long written() {
		return this.written;
	}

	/**
	 * The number of bytes transferred to the node
	 */
	@SuppressWarnings("unchecked")
	public Node written(Long value) {
		this.written = value;
		return (Node) this;
	}

	public NodeResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context objects.
	 */
	@SuppressWarnings("unchecked")
	public Node contexts(
			List<org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context> value) {
		this.subresources.contexts.addAll(value);
		return (Node) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Node context(Context value) {
		this.subresources.contexts.add(value);
		return (Node) this;
	}

	/**
	 * Child mutators for Node
	 */
	public class NodeResources {
		/**
		 * Runtime representation of a mod_cluster context
		 */
		private List<org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context> contexts = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node.Context resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Context> contexts() {
			return this.contexts;
		}
	}
}