package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.node;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Runtime representation of a mod_cluster context
 */
@ResourceType("context")
public class Context {

	private String key;
	private Integer requests;
	private String status;

	public Context(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of requests against this context
	 */
	@ModelNodeBinding(detypedName = "requests")
	public Integer requests() {
		return this.requests;
	}

	/**
	 * The number of requests against this context
	 */
	@SuppressWarnings("unchecked")
	public Context requests(Integer value) {
		this.requests = value;
		return (Context) this;
	}

	/**
	 * The status of this context
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * The status of this context
	 */
	@SuppressWarnings("unchecked")
	public Context status(String value) {
		this.status = value;
		return (Context) this;
	}
}