package org.wildfly.swarm.config.undertow.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * http listener
 */
@ResourceType("ajp-listener")
public class AjpListener {

	private String key;
	private Boolean allowEncodedSlash;
	private Boolean allowEqualsInCookieValue;
	private Boolean alwaysSetKeepAlive;
	private Boolean bufferPipelinedData;
	private String bufferPool;
	private Long bytesReceived;
	private Long bytesSent;
	private Boolean decodeUrl;
	private List<String> disallowedMethods;
	private Boolean enabled;
	private Long errorCount;
	private Integer maxBufferedRequestSize;
	private Integer maxConnections;
	private Integer maxCookies;
	private Integer maxHeaderSize;
	private Integer maxHeaders;
	private Integer maxParameters;
	private Long maxPostSize;
	private Long maxProcessingTime;
	private Integer noRequestTimeout;
	private Long processingTime;
	private Integer readTimeout;
	private Integer receiveBuffer;
	private Boolean recordRequestStartTime;
	private String redirectSocket;
	private Long requestCount;
	private Integer requestParseTimeout;
	private Boolean resolvePeerAddress;
	private String scheme;
	private Integer sendBuffer;
	private String socketBinding;
	private Integer tcpBacklog;
	private Boolean tcpKeepAlive;
	private String urlCharset;
	private String worker;
	private Integer writeTimeout;

	public AjpListener(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If a request comes in with encoded / characters (i.e. %2F), will these be decoded.
	 */
	@ModelNodeBinding(detypedName = "allow-encoded-slash")
	public Boolean allowEncodedSlash() {
		return this.allowEncodedSlash;
	}

	/**
	 * If a request comes in with encoded / characters (i.e. %2F), will these be decoded.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener allowEncodedSlash(Boolean value) {
		this.allowEncodedSlash = value;
		return (AjpListener) this;
	}

	/**
	 * If this is true then Undertow will allow non-escaped equals characters in unquoted cookie values. Unquoted cookie values may not contain equals characters. If present the value ends before the equals sign. The remainder of the cookie value will be dropped.
	 */
	@ModelNodeBinding(detypedName = "allow-equals-in-cookie-value")
	public Boolean allowEqualsInCookieValue() {
		return this.allowEqualsInCookieValue;
	}

	/**
	 * If this is true then Undertow will allow non-escaped equals characters in unquoted cookie values. Unquoted cookie values may not contain equals characters. If present the value ends before the equals sign. The remainder of the cookie value will be dropped.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener allowEqualsInCookieValue(Boolean value) {
		this.allowEqualsInCookieValue = value;
		return (AjpListener) this;
	}

	/**
	 * If this is true then a Connection: keep-alive header will be added to responses, even when it is not strictly required by the specification.
	 */
	@ModelNodeBinding(detypedName = "always-set-keep-alive")
	public Boolean alwaysSetKeepAlive() {
		return this.alwaysSetKeepAlive;
	}

	/**
	 * If this is true then a Connection: keep-alive header will be added to responses, even when it is not strictly required by the specification.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener alwaysSetKeepAlive(Boolean value) {
		this.alwaysSetKeepAlive = value;
		return (AjpListener) this;
	}

	/**
	 * If we should buffer pipelined requests.
	 */
	@ModelNodeBinding(detypedName = "buffer-pipelined-data")
	public Boolean bufferPipelinedData() {
		return this.bufferPipelinedData;
	}

	/**
	 * If we should buffer pipelined requests.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener bufferPipelinedData(Boolean value) {
		this.bufferPipelinedData = value;
		return (AjpListener) this;
	}

	/**
	 * The AJP listeners buffer pool
	 */
	@ModelNodeBinding(detypedName = "buffer-pool")
	public String bufferPool() {
		return this.bufferPool;
	}

	/**
	 * The AJP listeners buffer pool
	 */
	@SuppressWarnings("unchecked")
	public AjpListener bufferPool(String value) {
		this.bufferPool = value;
		return (AjpListener) this;
	}

	/**
	 * The number of bytes that have been received by this listener
	 */
	@ModelNodeBinding(detypedName = "bytes-received")
	public Long bytesReceived() {
		return this.bytesReceived;
	}

	/**
	 * The number of bytes that have been received by this listener
	 */
	@SuppressWarnings("unchecked")
	public AjpListener bytesReceived(Long value) {
		this.bytesReceived = value;
		return (AjpListener) this;
	}

	/**
	 * The number of bytes that have been sent out on this listener
	 */
	@ModelNodeBinding(detypedName = "bytes-sent")
	public Long bytesSent() {
		return this.bytesSent;
	}

	/**
	 * The number of bytes that have been sent out on this listener
	 */
	@SuppressWarnings("unchecked")
	public AjpListener bytesSent(Long value) {
		this.bytesSent = value;
		return (AjpListener) this;
	}

	/**
	 * If this is true then the parser will decode the URL and query parameters using the selected character encoding (UTF-8 by default). If this is false they will not be decoded. This will allow a later handler to decode them into whatever charset is desired.
	 */
	@ModelNodeBinding(detypedName = "decode-url")
	public Boolean decodeUrl() {
		return this.decodeUrl;
	}

	/**
	 * If this is true then the parser will decode the URL and query parameters using the selected character encoding (UTF-8 by default). If this is false they will not be decoded. This will allow a later handler to decode them into whatever charset is desired.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener decodeUrl(Boolean value) {
		this.decodeUrl = value;
		return (AjpListener) this;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@ModelNodeBinding(detypedName = "disallowed-methods")
	public List<String> disallowedMethods() {
		return this.disallowedMethods;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@SuppressWarnings("unchecked")
	public AjpListener disallowedMethods(List<String> value) {
		this.disallowedMethods = value;
		return (AjpListener) this;
	}

	/**
	 * If the listener is enabled
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If the listener is enabled
	 */
	@SuppressWarnings("unchecked")
	public AjpListener enabled(Boolean value) {
		this.enabled = value;
		return (AjpListener) this;
	}

	/**
	 * The number of 500 responses that have been sent by this listener
	 */
	@ModelNodeBinding(detypedName = "error-count")
	public Long errorCount() {
		return this.errorCount;
	}

	/**
	 * The number of 500 responses that have been sent by this listener
	 */
	@SuppressWarnings("unchecked")
	public AjpListener errorCount(Long value) {
		this.errorCount = value;
		return (AjpListener) this;
	}

	/**
	 * Maximum size of a buffered request, in bytesRequests are not usually buffered, the most common case is when performing SSL renegotiation for a POST request, and the post data must be fullybuffered in order to perform the renegotiation.
	 */
	@ModelNodeBinding(detypedName = "max-buffered-request-size")
	public Integer maxBufferedRequestSize() {
		return this.maxBufferedRequestSize;
	}

	/**
	 * Maximum size of a buffered request, in bytesRequests are not usually buffered, the most common case is when performing SSL renegotiation for a POST request, and the post data must be fullybuffered in order to perform the renegotiation.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxBufferedRequestSize(Integer value) {
		this.maxBufferedRequestSize = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum number of concurrent connections.
	 */
	@ModelNodeBinding(detypedName = "max-connections")
	public Integer maxConnections() {
		return this.maxConnections;
	}

	/**
	 * The maximum number of concurrent connections.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxConnections(Integer value) {
		this.maxConnections = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum number of cookies that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@ModelNodeBinding(detypedName = "max-cookies")
	public Integer maxCookies() {
		return this.maxCookies;
	}

	/**
	 * The maximum number of cookies that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxCookies(Integer value) {
		this.maxCookies = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum size in bytes of a http request header.
	 */
	@ModelNodeBinding(detypedName = "max-header-size")
	public Integer maxHeaderSize() {
		return this.maxHeaderSize;
	}

	/**
	 * The maximum size in bytes of a http request header.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxHeaderSize(Integer value) {
		this.maxHeaderSize = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum number of headers that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@ModelNodeBinding(detypedName = "max-headers")
	public Integer maxHeaders() {
		return this.maxHeaders;
	}

	/**
	 * The maximum number of headers that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxHeaders(Integer value) {
		this.maxHeaders = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum number of parameters that will be parsed. This is used to protect against hash vulnerabilities.This applies to both query parameters, and to POST data, but is not cumulative (i.e. you can potentially have max parameters * 2 total parameters).
	 */
	@ModelNodeBinding(detypedName = "max-parameters")
	public Integer maxParameters() {
		return this.maxParameters;
	}

	/**
	 * The maximum number of parameters that will be parsed. This is used to protect against hash vulnerabilities.This applies to both query parameters, and to POST data, but is not cumulative (i.e. you can potentially have max parameters * 2 total parameters).
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxParameters(Integer value) {
		this.maxParameters = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum size of a post that will be accepted
	 */
	@ModelNodeBinding(detypedName = "max-post-size")
	public Long maxPostSize() {
		return this.maxPostSize;
	}

	/**
	 * The maximum size of a post that will be accepted
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxPostSize(Long value) {
		this.maxPostSize = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum processing time taken by a request on this listener
	 */
	@ModelNodeBinding(detypedName = "max-processing-time")
	public Long maxProcessingTime() {
		return this.maxProcessingTime;
	}

	/**
	 * The maximum processing time taken by a request on this listener
	 */
	@SuppressWarnings("unchecked")
	public AjpListener maxProcessingTime(Long value) {
		this.maxProcessingTime = value;
		return (AjpListener) this;
	}

	/**
	 * The length of time in milliseconds that the connection can be idle before it is closed by the container
	 */
	@ModelNodeBinding(detypedName = "no-request-timeout")
	public Integer noRequestTimeout() {
		return this.noRequestTimeout;
	}

	/**
	 * The length of time in milliseconds that the connection can be idle before it is closed by the container
	 */
	@SuppressWarnings("unchecked")
	public AjpListener noRequestTimeout(Integer value) {
		this.noRequestTimeout = value;
		return (AjpListener) this;
	}

	/**
	 * The total processing time of all requests handed by this listener
	 */
	@ModelNodeBinding(detypedName = "processing-time")
	public Long processingTime() {
		return this.processingTime;
	}

	/**
	 * The total processing time of all requests handed by this listener
	 */
	@SuppressWarnings("unchecked")
	public AjpListener processingTime(Long value) {
		this.processingTime = value;
		return (AjpListener) this;
	}

	/**
	 * Configure a read timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful read taking place, the socket's next read will throw a {@link ReadTimeoutException}.
	 */
	@ModelNodeBinding(detypedName = "read-timeout")
	public Integer readTimeout() {
		return this.readTimeout;
	}

	/**
	 * Configure a read timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful read taking place, the socket's next read will throw a {@link ReadTimeoutException}.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener readTimeout(Integer value) {
		this.readTimeout = value;
		return (AjpListener) this;
	}

	/**
	 * The receive buffer size.
	 */
	@ModelNodeBinding(detypedName = "receive-buffer")
	public Integer receiveBuffer() {
		return this.receiveBuffer;
	}

	/**
	 * The receive buffer size.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener receiveBuffer(Integer value) {
		this.receiveBuffer = value;
		return (AjpListener) this;
	}

	/**
	 * If this is true then Undertow will record the request start time, to allow for request time to be logged. This has a small but measurable performance impact
	 */
	@ModelNodeBinding(detypedName = "record-request-start-time")
	public Boolean recordRequestStartTime() {
		return this.recordRequestStartTime;
	}

	/**
	 * If this is true then Undertow will record the request start time, to allow for request time to be logged. This has a small but measurable performance impact
	 */
	@SuppressWarnings("unchecked")
	public AjpListener recordRequestStartTime(Boolean value) {
		this.recordRequestStartTime = value;
		return (AjpListener) this;
	}

	/**
	 * If this listener is supporting non-SSL requests, and a request is received for which a matching <security-constraint> requires SSL transport, undertow will automatically redirect the request to the socket binding port specified here.
	 */
	@ModelNodeBinding(detypedName = "redirect-socket")
	public String redirectSocket() {
		return this.redirectSocket;
	}

	/**
	 * If this listener is supporting non-SSL requests, and a request is received for which a matching <security-constraint> requires SSL transport, undertow will automatically redirect the request to the socket binding port specified here.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener redirectSocket(String value) {
		this.redirectSocket = value;
		return (AjpListener) this;
	}

	/**
	 * The number of requests this listener has served
	 */
	@ModelNodeBinding(detypedName = "request-count")
	public Long requestCount() {
		return this.requestCount;
	}

	/**
	 * The number of requests this listener has served
	 */
	@SuppressWarnings("unchecked")
	public AjpListener requestCount(Long value) {
		this.requestCount = value;
		return (AjpListener) this;
	}

	/**
	 * The maximum amount of time (in milliseconds) that can be spent parsing the request
	 */
	@ModelNodeBinding(detypedName = "request-parse-timeout")
	public Integer requestParseTimeout() {
		return this.requestParseTimeout;
	}

	/**
	 * The maximum amount of time (in milliseconds) that can be spent parsing the request
	 */
	@SuppressWarnings("unchecked")
	public AjpListener requestParseTimeout(Integer value) {
		this.requestParseTimeout = value;
		return (AjpListener) this;
	}

	/**
	 * Enables host dns lookup
	 */
	@ModelNodeBinding(detypedName = "resolve-peer-address")
	public Boolean resolvePeerAddress() {
		return this.resolvePeerAddress;
	}

	/**
	 * Enables host dns lookup
	 */
	@SuppressWarnings("unchecked")
	public AjpListener resolvePeerAddress(Boolean value) {
		this.resolvePeerAddress = value;
		return (AjpListener) this;
	}

	/**
	 * The listener scheme, can be HTTP or HTTPS. By default the scheme will be taken from the incoming AJP request.
	 */
	@ModelNodeBinding(detypedName = "scheme")
	public String scheme() {
		return this.scheme;
	}

	/**
	 * The listener scheme, can be HTTP or HTTPS. By default the scheme will be taken from the incoming AJP request.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener scheme(String value) {
		this.scheme = value;
		return (AjpListener) this;
	}

	/**
	 * The send buffer size.
	 */
	@ModelNodeBinding(detypedName = "send-buffer")
	public Integer sendBuffer() {
		return this.sendBuffer;
	}

	/**
	 * The send buffer size.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener sendBuffer(Integer value) {
		this.sendBuffer = value;
		return (AjpListener) this;
	}

	/**
	 * The AJP listener socket binder
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The AJP listener socket binder
	 */
	@SuppressWarnings("unchecked")
	public AjpListener socketBinding(String value) {
		this.socketBinding = value;
		return (AjpListener) this;
	}

	/**
	 * Configure a server with the specified backlog.
	 */
	@ModelNodeBinding(detypedName = "tcp-backlog")
	public Integer tcpBacklog() {
		return this.tcpBacklog;
	}

	/**
	 * Configure a server with the specified backlog.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener tcpBacklog(Integer value) {
		this.tcpBacklog = value;
		return (AjpListener) this;
	}

	/**
	 * Configure a channel to send TCP keep-alive messages in an implementation-dependent manner.
	 */
	@ModelNodeBinding(detypedName = "tcp-keep-alive")
	public Boolean tcpKeepAlive() {
		return this.tcpKeepAlive;
	}

	/**
	 * Configure a channel to send TCP keep-alive messages in an implementation-dependent manner.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener tcpKeepAlive(Boolean value) {
		this.tcpKeepAlive = value;
		return (AjpListener) this;
	}

	/**
	 * URL charset
	 */
	@ModelNodeBinding(detypedName = "url-charset")
	public String urlCharset() {
		return this.urlCharset;
	}

	/**
	 * URL charset
	 */
	@SuppressWarnings("unchecked")
	public AjpListener urlCharset(String value) {
		this.urlCharset = value;
		return (AjpListener) this;
	}

	/**
	 * The AJP listeners XNIO worker
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * The AJP listeners XNIO worker
	 */
	@SuppressWarnings("unchecked")
	public AjpListener worker(String value) {
		this.worker = value;
		return (AjpListener) this;
	}

	/**
	 * Configure a write timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful write taking place, the socket's next write will throw a {@link WriteTimeoutException}.
	 */
	@ModelNodeBinding(detypedName = "write-timeout")
	public Integer writeTimeout() {
		return this.writeTimeout;
	}

	/**
	 * Configure a write timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful write taking place, the socket's next write will throw a {@link WriteTimeoutException}.
	 */
	@SuppressWarnings("unchecked")
	public AjpListener writeTimeout(Integer value) {
		this.writeTimeout = value;
		return (AjpListener) this;
	}
}