package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The access log configuration for this virtual server.
 */
@ResourceType("setting")
@Implicit
public class AccessLogSetting {

	private String key;
	private String directory;
	private Boolean extended;
	private String pattern;
	private String predicate;
	private String prefix;
	private String relativeTo;
	private Boolean rotate;
	private String suffix;
	private Boolean useServerLog;
	private String worker;

	public AccessLogSetting() {
		this.key = "access-log";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Directory in which to save logs
	 */
	@ModelNodeBinding(detypedName = "directory")
	public String directory() {
		return this.directory;
	}

	/**
	 * Directory in which to save logs
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting directory(String value) {
		this.directory = value;
		return (AccessLogSetting) this;
	}

	/**
	 * If the log uses the extended log file format
	 */
	@ModelNodeBinding(detypedName = "extended")
	public Boolean extended() {
		return this.extended;
	}

	/**
	 * If the log uses the extended log file format
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting extended(Boolean value) {
		this.extended = value;
		return (AccessLogSetting) this;
	}

	/**
	 * The access log pattern.
	 */
	@ModelNodeBinding(detypedName = "pattern")
	public String pattern() {
		return this.pattern;
	}

	/**
	 * The access log pattern.
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting pattern(String value) {
		this.pattern = value;
		return (AccessLogSetting) this;
	}

	/**
	 * Predicate that determines if the request should be logged
	 */
	@ModelNodeBinding(detypedName = "predicate")
	public String predicate() {
		return this.predicate;
	}

	/**
	 * Predicate that determines if the request should be logged
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting predicate(String value) {
		this.predicate = value;
		return (AccessLogSetting) this;
	}

	/**
	 * Prefix for the log file name.
	 */
	@ModelNodeBinding(detypedName = "prefix")
	public String prefix() {
		return this.prefix;
	}

	/**
	 * Prefix for the log file name.
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting prefix(String value) {
		this.prefix = value;
		return (AccessLogSetting) this;
	}

	/**
	 * The directory the path is relative to
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The directory the path is relative to
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting relativeTo(String value) {
		this.relativeTo = value;
		return (AccessLogSetting) this;
	}

	/**
	 * Rotate the access log every day.
	 */
	@ModelNodeBinding(detypedName = "rotate")
	public Boolean rotate() {
		return this.rotate;
	}

	/**
	 * Rotate the access log every day.
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting rotate(Boolean value) {
		this.rotate = value;
		return (AccessLogSetting) this;
	}

	/**
	 * Suffix for the log file name.
	 */
	@ModelNodeBinding(detypedName = "suffix")
	public String suffix() {
		return this.suffix;
	}

	/**
	 * Suffix for the log file name.
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting suffix(String value) {
		this.suffix = value;
		return (AccessLogSetting) this;
	}

	/**
	 * If the log should be written to the server log, rather than a separate file. Defaults to false.
	 */
	@ModelNodeBinding(detypedName = "use-server-log")
	public Boolean useServerLog() {
		return this.useServerLog;
	}

	/**
	 * If the log should be written to the server log, rather than a separate file. Defaults to false.
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting useServerLog(Boolean value) {
		this.useServerLog = value;
		return (AccessLogSetting) this;
	}

	/**
	 * Name of the worker to use for logging
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * Name of the worker to use for logging
	 */
	@SuppressWarnings("unchecked")
	public AccessLogSetting worker(String value) {
		this.worker = value;
		return (AccessLogSetting) this;
	}
}