package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ResourceType;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Reference to filter
 */
@ResourceType("filter-ref")
public class FilterRef {

	private String key;
	private String predicate;
	private Integer priority;

	public FilterRef(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Predicates provide a simple way of making a true/false decision  based on an exchange. Many handlers have a requirement that they be applied conditionally, and predicates provide a general way to specify a condition.
	 */
	@ModelNodeBinding(detypedName = "predicate")
	public String predicate() {
		return this.predicate;
	}

	/**
	 * Predicates provide a simple way of making a true/false decision  based on an exchange. Many handlers have a requirement that they be applied conditionally, and predicates provide a general way to specify a condition.
	 */
	@SuppressWarnings("unchecked")
	public FilterRef predicate(String value) {
		this.predicate = value;
		return (FilterRef) this;
	}

	/**
	 * Defines filter order, it should be set to 1 or more, higher number instructs server to be included earlier in handler chain than others under same context.
	 */
	@ModelNodeBinding(detypedName = "priority")
	public Integer priority() {
		return this.priority;
	}

	/**
	 * Defines filter order, it should be set to 1 or more, higher number instructs server to be included earlier in handler chain than others under same context.
	 */
	@SuppressWarnings("unchecked")
	public FilterRef priority(Integer value) {
		this.priority = value;
		return (FilterRef) this;
	}
}