/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.config.invocation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;

public class IndexFactory {
    public static final DotName IMPLICIT_META = DotName.createSimple((String)Implicit.class.getCanonicalName());
    public static final DotName BINDING_META = DotName.createSimple((String)ModelNodeBinding.class.getCanonicalName());
    public static final DotName ADDRESS_META = DotName.createSimple((String)Address.class.getCanonicalName());
    public static final DotName SUBRESOURCE_META = DotName.createSimple((String)Subresource.class.getCanonicalName());
    private static final HashMap<Class<?>, Index> indices = new HashMap();

    public static synchronized Index createIndex(Class<?> type) {
        Index index = indices.get(type);
        if (index == null) {
            try {
                Indexer indexer = new Indexer();
                for (Class<?> currentType = type; currentType != null; currentType = currentType.getSuperclass()) {
                    String className = currentType.getName().replace(".", "/") + ".class";
                    InputStream stream = type.getClassLoader().getResourceAsStream(className);
                    indexer.index(stream);
                }
                index = indexer.complete();
                indices.put(type, index);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize Indexer", e);
            }
        }
        return index;
    }
}

