/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5;

import java.util.Map;
import java.util.Properties;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitInfo;
import org.jboss.as.jpa.hibernate5.HibernateArchiveScanner;
import org.jboss.as.jpa.hibernate5.HibernateExtendedBeanManager;
import org.jboss.as.jpa.hibernate5.HibernateSecondLevelCache;
import org.jboss.as.jpa.hibernate5.JpaLogger;
import org.jboss.as.jpa.hibernate5.TwoPhaseBootstrapImpl;
import org.jboss.as.jpa.hibernate5.management.HibernateManagementAdaptor;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.event.impl.internal.Notification;
import org.jipijapa.plugin.spi.EntityManagerFactoryBuilder;
import org.jipijapa.plugin.spi.JtaManager;
import org.jipijapa.plugin.spi.ManagementAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.Platform;
import org.jipijapa.plugin.spi.TwoPhaseBootstrapCapable;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor,
TwoPhaseBootstrapCapable {
    public static final String NAMING_STRATEGY_JPA_COMPLIANT_IMPL = "org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl";
    private volatile Platform platform;
    private static final String SHARED_CACHE_MODE = "javax.persistence.sharedCache.mode";
    private static final String NONE = SharedCacheMode.NONE.name();
    private static final String UNSPECIFIED = SharedCacheMode.UNSPECIFIED.name();
    private static final String HIBERNATE_EXTENDED_BEANMANAGER = "org.hibernate.jpa.event.spi.jpa.ExtendedBeanManager";

    public void injectJtaManager(JtaManager jtaManager) {
    }

    public void injectPlatform(Platform platform) {
        if (this.platform != platform) {
            this.platform = platform;
        }
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        this.putPropertyIfAbsent(pu, properties, "hibernate.query.jpaql_strict_compliance", "true");
        this.putPropertyIfAbsent(pu, properties, "hibernate.id.new_generator_mappings", "true");
        this.putPropertyIfAbsent(pu, properties, "hibernate.auto_quote_keyword", "false");
        this.putPropertyIfAbsent(pu, properties, "hibernate.implicit_naming_strategy", NAMING_STRATEGY_JPA_COMPLIANT_IMPL);
        this.putPropertyIfAbsent(pu, properties, "hibernate.archive.scanner", HibernateArchiveScanner.class);
        properties.put("hibernate.classLoader.application", pu.getClassLoader());
        this.putPropertyIfAbsent(pu, properties, "hibernate.ejb.entitymanager_factory_name", pu.getScopedPersistenceUnitName());
        this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name", pu.getScopedPersistenceUnitName());
        if (!pu.getProperties().containsKey("hibernate.session_factory_name")) {
            this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name_is_jndi", Boolean.FALSE);
        }
        this.putPropertyIfAbsent(pu, properties, "hibernate.model.generator_name_as_sequence_name", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance.transaction", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance.closed", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance.query", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance.list", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance.caching", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance.proxy", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.enable_lazy_load_no_trans", false);
        this.putPropertyIfAbsent(pu, properties, "hibernate.jpa.compliance.global_id_generators", true);
        this.putPropertyIfAbsent(pu, properties, "hibernate.search.index_uninverting_allowed", "true");
    }

    public void addProviderDependencies(PersistenceUnitMetadata pu) {
        boolean sharedCacheDisabled;
        Properties properties = pu.getProperties();
        String sharedCacheMode = properties.getProperty(SHARED_CACHE_MODE);
        if (Classification.NONE.equals((Object)this.platform.defaultCacheClassification())) {
            JpaLogger.JPA_LOGGER.tracef("second level cache is not supported in platform, ignoring shared cache mode", new Object[0]);
            pu.setSharedCacheMode(SharedCacheMode.NONE);
        }
        boolean bl = sharedCacheDisabled = SharedCacheMode.NONE.equals((Object)pu.getSharedCacheMode()) || NONE.equals(sharedCacheMode) || SharedCacheMode.UNSPECIFIED.equals((Object)pu.getSharedCacheMode()) || UNSPECIFIED.equals(sharedCacheMode);
        if (!sharedCacheDisabled && (null == properties.getProperty("hibernate.cache.use_second_level_cache") || Boolean.parseBoolean(properties.getProperty("hibernate.cache.use_second_level_cache")))) {
            HibernateSecondLevelCache.addSecondLevelCacheDependencies(pu.getProperties(), pu.getScopedPersistenceUnitName());
            JpaLogger.JPA_LOGGER.tracef("second level cache enabled for %s", pu.getScopedPersistenceUnitName());
        } else {
            JpaLogger.JPA_LOGGER.tracef("second level cache disabled for %s, pu %s property = %s, pu.getSharedCacheMode = %s", new Object[]{pu.getScopedPersistenceUnitName(), SHARED_CACHE_MODE, sharedCacheMode, pu.getSharedCacheMode().toString()});
            pu.setSharedCacheMode(SharedCacheMode.NONE);
        }
    }

    private void putPropertyIfAbsent(PersistenceUnitMetadata pu, Map properties, String property, Object value) {
        if (!pu.getProperties().containsKey(property)) {
            properties.put(property, value);
        }
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        Notification.beforeEntityManagerFactoryCreate((Classification)Classification.INFINISPAN, (PersistenceUnitMetadata)pu);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        Notification.afterEntityManagerFactoryCreate((Classification)Classification.INFINISPAN, (PersistenceUnitMetadata)pu);
    }

    public ManagementAdaptor getManagementAdaptor() {
        return HibernateManagementAdaptor.getInstance();
    }

    public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
        String cacheRegionPrefix = pu.getProperties().getProperty("hibernate.cache.region_prefix");
        return cacheRegionPrefix == null || cacheRegionPrefix.equals(pu.getScopedPersistenceUnitName());
    }

    public void cleanup(PersistenceUnitMetadata pu) {
    }

    public Object beanManagerLifeCycle(BeanManager beanManager) {
        if (this.isHibernateExtendedBeanManagerSupported()) {
            return new HibernateExtendedBeanManager(beanManager);
        }
        return null;
    }

    public void markPersistenceUnitAvailable(Object wrapperBeanManagerLifeCycle) {
        if (this.isHibernateExtendedBeanManagerSupported()) {
            HibernateExtendedBeanManager hibernateExtendedBeanManager = (HibernateExtendedBeanManager)wrapperBeanManagerLifeCycle;
            hibernateExtendedBeanManager.beanManagerIsAvailableForUse();
        }
    }

    private boolean isHibernateExtendedBeanManagerSupported() {
        try {
            Class.forName(HIBERNATE_EXTENDED_BEANMANAGER);
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
    }

    public EntityManagerFactoryBuilder getBootstrap(PersistenceUnitInfo info, Map map) {
        return new TwoPhaseBootstrapImpl(info, map);
    }
}

