/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.util.Arrays;
import org.jboss.logging.Logger;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.DistributionInfo;
import org.wildfly.prospero.cli.ExecutionExceptionHandler;
import org.wildfly.prospero.cli.UnknownCommandParameterExceptionHandler;
import org.wildfly.prospero.cli.commands.ChannelCommand;
import org.wildfly.prospero.cli.commands.CloneCommand;
import org.wildfly.prospero.cli.commands.CompletionCommand;
import org.wildfly.prospero.cli.commands.FeaturesCommand;
import org.wildfly.prospero.cli.commands.HistoryCommand;
import org.wildfly.prospero.cli.commands.InstallCommand;
import org.wildfly.prospero.cli.commands.MainCommand;
import org.wildfly.prospero.cli.commands.PrintLicensesCommand;
import org.wildfly.prospero.cli.commands.RevertCommand;
import org.wildfly.prospero.cli.commands.UpdateCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelAddCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelInitializeCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelPromoteCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelRemoveCommand;
import picocli.CommandLine;

public class CliMain {
    static final Logger logger;

    private static void enableJBossLogManager() {
        if (System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        }
    }

    public static void main(String[] args) {
        try {
            int exitCode = CliMain.execute(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            CliMain.logException(e);
            System.exit(1);
        }
    }

    public static CommandLine createCommandLine(CliConsole console, String[] args) {
        return CliMain.createCommandLine(console, args, new ActionFactory());
    }

    public static CommandLine createCommandLine(CliConsole console, String[] args, ActionFactory actionFactory) {
        CommandLine commandLine = new CommandLine((Object)new MainCommand(console));
        commandLine.setCommandName(DistributionInfo.DIST_NAME);
        commandLine.addSubcommand((Object)new InstallCommand(console, actionFactory));
        UpdateCommand updateCommand = new UpdateCommand(console, actionFactory);
        commandLine.addSubcommand((Object)updateCommand);
        updateCommand.addSubCommands(commandLine);
        commandLine.addSubcommand((Object)new PrintLicensesCommand(console, actionFactory));
        commandLine.addSubcommand((Object)new HistoryCommand(console, actionFactory));
        RevertCommand revertCommand = new RevertCommand(console, actionFactory);
        commandLine.addSubcommand((Object)revertCommand);
        revertCommand.addSubCommands(commandLine);
        commandLine.addSubcommand((Object)new ChannelCommand(console, actionFactory));
        commandLine.addSubcommand((Object)new CompletionCommand());
        CommandLine channelCmd = (CommandLine)commandLine.getSubcommands().get("channel");
        channelCmd.addSubcommand((Object)new ChannelAddCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelRemoveCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelCommand.ChannelListCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelCommand.ChannelVersionCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelInitializeCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelPromoteCommand(console, actionFactory));
        CloneCommand cloneCommand = new CloneCommand(console, actionFactory);
        commandLine.addSubcommand((Object)cloneCommand);
        cloneCommand.addSubCommands(commandLine);
        FeaturesCommand featuresCommand = new FeaturesCommand(console, actionFactory);
        commandLine.addSubcommand((Object)featuresCommand);
        featuresCommand.addSubCommands(commandLine);
        commandLine.setUsageHelpAutoWidth(true);
        boolean isVerbose = Arrays.stream(args).anyMatch(s -> s.equals("-vv") || s.equals("--verbose"));
        CommandLine.IParameterExceptionHandler rootParameterExceptionHandler = commandLine.getParameterExceptionHandler();
        commandLine.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExecutionExceptionHandler(console, isVerbose));
        commandLine.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new UnknownCommandParameterExceptionHandler(rootParameterExceptionHandler, System.err));
        return commandLine;
    }

    static int execute(String[] args) {
        CliConsole console = new CliConsole();
        CommandLine commandLine = CliMain.createCommandLine(console, args);
        return commandLine.execute(args);
    }

    static void logException(Exception e) {
        System.err.println(CliMessages.MESSAGES.errorWhenProcessingCommand() + e.getMessage());
        logger.error((Object)CliMessages.MESSAGES.errorWhenProcessingCommand(), (Throwable)e);
    }

    static {
        CliMain.enableJBossLogManager();
        logger = Logger.getLogger(CliMain.class);
    }
}

