/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.bean_validation_custom_constraint;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jboss.as.quickstarts.bean_validation_custom_constraint.Address;
import org.jboss.as.quickstarts.bean_validation_custom_constraint.PersonAddress;

@Entity
@Table(name="person")
public class Person
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    @Column(name="person_id")
    private Long personId;
    @NotNull
    @Size(min=4)
    private String firstName;
    @NotNull
    @Size(min=4)
    private String lastName;
    @NotNull
    @Address
    @OneToOne(mappedBy="person", cascade={CascadeType.ALL})
    private PersonAddress personAddress;

    public Person() {
    }

    public Person(String firstName, String lastName, PersonAddress address) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.personAddress = address;
    }

    public Long getId() {
        return this.personId;
    }

    public void setId(Long id) {
        this.personId = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public PersonAddress getPersonAddress() {
        return this.personAddress;
    }

    public void setPersonAddress(PersonAddress personAddress) {
        this.personAddress = personAddress;
    }
}

