/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb.asynchronous.client;

import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.quickstarts.ejb.asynchronous.AsynchronousAccess;
import org.jboss.as.quickstarts.ejb.asynchronous.ParallelAccess;

public class AsynchronousClient {
    private static final Logger LOGGER = Logger.getLogger(AsynchronousClient.class.getName());
    private final AsynchronousAccess accessBean;
    private final ParallelAccess parallelBean;

    private AsynchronousClient() throws NamingException {
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        InitialContext context = new InitialContext(jndiProperties);
        String lookupName = "ejb:/ejb-asynchronous-ejb/AsynchronousAccessBean!" + AsynchronousAccess.class.getName();
        LOGGER.info("Lookup Bean >" + lookupName);
        this.accessBean = (AsynchronousAccess)context.lookup(lookupName);
        lookupName = "ejb:/ejb-asynchronous-ejb/ParallelAccessBean!" + ParallelAccess.class.getName();
        LOGGER.info("Lookup Bean >" + lookupName);
        this.parallelBean = (ParallelAccess)context.lookup(lookupName);
    }

    private void fireAndForget() throws InterruptedException {
        long sleepMillis = 15000L;
        this.accessBean.fireAndForget(sleepMillis);
        LOGGER.info(String.format("The server log should contain a message at (about) %s, indicating that the call to the asynchronous bean completed.", new Date(new Date().getTime() + sleepMillis)));
    }

    private void getResultAsync() throws InterruptedException, ExecutionException, TimeoutException {
        Future myResult = this.accessBean.longerRunning(200L);
        Thread.sleep(400L);
        LOGGER.info("Got the async result as expected => " + (String)myResult.get(1L, TimeUnit.MILLISECONDS));
    }

    private void waitForAsyncResult() throws InterruptedException, ExecutionException, TimeoutException {
        Future myResult = this.accessBean.longerRunning(1500L);
        LOGGER.info("Got the async result as expected after wait => " + (String)myResult.get());
    }

    private void callAnEJBwithAsyncAccess() {
        Collection results = this.parallelBean.invokeAsyncParallel();
        LOGGER.info("Results of the parallel (server) processing : " + results);
    }

    private void waitForAnotherAsyncResult2() throws InterruptedException, ExecutionException, TimeoutException {
        this.parallelBean.callInterfaceAnnotatedMethod();
    }

    private void callAsyncWithFailure() throws InterruptedException {
        Future x;
        try {
            x = this.accessBean.failure();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unexpected failure during start asynchronous execution!", e);
        }
        try {
            x.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalAccessException) {
                LOGGER.info("Catch the expected Exception of the asynchronous execution!");
            }
            if (e.getCause().getCause() instanceof IllegalAccessException) {
                LOGGER.info("Catch the covered Exception of the asynchronous execution, you may be using an older release of JBoss EAP!");
            }
            throw new RuntimeException("Unexpected ExecutionException during asynchronous call!", e);
        }
    }

    public static void main(String[] args) throws Exception {
        AsynchronousClient client = new AsynchronousClient();
        client.fireAndForget();
        client.getResultAsync();
        client.waitForAsyncResult();
        client.callAsyncWithFailure();
        client.callAnEJBwithAsyncAccess();
        client.waitForAnotherAsyncResult2();
    }
}

