/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb.asynchronous;

import java.util.Date;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import org.jboss.as.quickstarts.ejb.asynchronous.AnotherAsynchronousAccess;
import org.jboss.as.quickstarts.ejb.asynchronous.AsynchronousAccess;

@Stateless
public class AsynchronousAccessBean
implements AsynchronousAccess,
AnotherAsynchronousAccess {
    private static final Logger LOGGER = Logger.getLogger(AsynchronousAccessBean.class.getName());

    @Override
    @Asynchronous
    public void fireAndForget(long sleepTime) {
        LOGGER.info("'fireAndForget' Will wait for " + sleepTime + "ms");
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOGGER.info("action 'fireAndForget' finished");
    }

    @Override
    @Asynchronous
    public Future<String> longerRunning(long sleepTime) {
        LOGGER.info("Will wait for " + sleepTime + "ms");
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOGGER.info("returning the result");
        return new AsyncResult((Object)("returning at " + new Date() + ", duration was " + sleepTime + "ms"));
    }

    @Override
    @Asynchronous
    public Future<String> failure() throws IllegalAccessException {
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new IllegalAccessException("Asynchrounous fail demonstration");
    }

    @Override
    public Future<String> interfaceAsync(long sleepTime) {
        LOGGER.info("Will wait for " + sleepTime + "ms");
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOGGER.info("returning the result");
        return new AsyncResult((Object)("returning at " + new Date() + ", duration was " + sleepTime + "ms"));
    }
}

