/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb.multi.server.app;

import java.security.Principal;
import java.util.Hashtable;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.quickstarts.ejb.multi.server.app.AppOne;
import org.jboss.as.quickstarts.ejb.multi.server.app.AppTwo;
import org.jboss.as.quickstarts.ejb.multi.server.app.MainApp;
import org.jboss.logging.Logger;

@Stateless
public class MainAppBean
implements MainApp {
    private static final Logger LOGGER = Logger.getLogger(MainAppBean.class);
    @Resource
    SessionContext context;
    private InitialContext iCtx;
    @EJB(lookup="ejb:ejb-multi-server-app-one/ejb//AppOneBean!org.jboss.as.quickstarts.ejb.multi.server.app.AppOne")
    AppOne appOneProxy;

    @PostConstruct
    public void init() {
        try {
            Hashtable<String, String> p = new Hashtable<String, String>();
            p.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
            this.iCtx = new InitialContext(p);
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not initialize context", e);
        }
    }

    @Override
    public String getJBossNodeName() {
        return System.getProperty("jboss.node.name");
    }

    @Override
    public String invokeAll(String text) {
        Principal caller = this.context.getCallerPrincipal();
        LOGGER.info((Object)("[" + caller.getName() + "] " + text));
        StringBuilder result = new StringBuilder("MainApp[" + caller.getName() + "]@" + System.getProperty("jboss.node.name"));
        try {
            result.append("  >  [ " + this.invokeAppOne(text));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not invoke AppOne", (Throwable)e);
        }
        String lookup = "";
        try {
            lookup = "ejb:ejb-multi-server-app-two/ejb//AppTwoBean!" + AppTwo.class.getName();
            result.append(" > " + this.invokeAppTwo(lookup, text));
            LOGGER.info((Object)("Invoke '" + lookup + " OK"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not invoke apptwo '" + lookup + "'"), (Throwable)e);
        }
        try {
            lookup = "java:comp/env/AppTwoAlias";
            result.append(" ; " + this.invokeAppTwo(lookup, text));
            LOGGER.info((Object)("Invoke '" + lookup + " OK"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not invoke apptwo '" + lookup + "'"), (Throwable)e);
        }
        result.append(" ]");
        return result.toString();
    }

    private String invokeAppOne(String text) {
        try {
            String appOneResult = this.appOneProxy.invoke(text);
            LOGGER.info((Object)("AppOne return : " + appOneResult));
            return appOneResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke appOne", e);
        }
    }

    private String invokeAppTwo(String lookup, String text) throws NamingException {
        AppTwo bean = (AppTwo)this.iCtx.lookup(lookup);
        String appTwoResult = bean.invoke(text);
        LOGGER.info((Object)("AppTwo return : " + appTwoResult));
        return appTwoResult;
    }
}

