/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb.remote.client;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.quickstarts.ejb.remote.stateful.RemoteCounter;
import org.jboss.as.quickstarts.ejb.remote.stateless.RemoteCalculator;

public class RemoteEJBClient {
    public static void main(String[] args) throws Exception {
        RemoteEJBClient.invokeStatelessBean();
        RemoteEJBClient.invokeStatefulBean();
    }

    private static void invokeStatelessBean() throws NamingException {
        RemoteCalculator statelessRemoteCalculator = RemoteEJBClient.lookupRemoteStatelessCalculator();
        System.out.println("Obtained a remote stateless calculator for invocation");
        int a = 204;
        int b = 340;
        System.out.println("Adding " + a + " and " + b + " via the remote stateless calculator deployed on the server");
        int sum = statelessRemoteCalculator.add(a, b);
        System.out.println("Remote calculator returned sum = " + sum);
        if (sum != a + b) {
            throw new RuntimeException("Remote stateless calculator returned an incorrect sum " + sum + " ,expected sum was " + (a + b));
        }
        int num1 = 3434;
        int num2 = 2332;
        System.out.println("Subtracting " + num2 + " from " + num1 + " via the remote stateless calculator deployed on the server");
        int difference = statelessRemoteCalculator.subtract(num1, num2);
        System.out.println("Remote calculator returned difference = " + difference);
        if (difference != num1 - num2) {
            throw new RuntimeException("Remote stateless calculator returned an incorrect difference " + difference + " ,expected difference was " + (num1 - num2));
        }
    }

    private static void invokeStatefulBean() throws NamingException {
        int i;
        RemoteCounter statefulRemoteCounter = RemoteEJBClient.lookupRemoteStatefulCounter();
        System.out.println("Obtained a remote stateful counter for invocation");
        int NUM_TIMES = 5;
        System.out.println("Counter will now be incremented 5 times");
        for (i = 0; i < 5; ++i) {
            System.out.println("Incrementing counter");
            statefulRemoteCounter.increment();
            System.out.println("Count after increment is " + statefulRemoteCounter.getCount());
        }
        System.out.println("Counter will now be decremented 5 times");
        for (i = 5; i > 0; --i) {
            System.out.println("Decrementing counter");
            statefulRemoteCounter.decrement();
            System.out.println("Count after decrement is " + statefulRemoteCounter.getCount());
        }
    }

    private static RemoteCalculator lookupRemoteStatelessCalculator() throws NamingException {
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.initial", "org.wildfly.naming.client.WildFlyInitialContextFactory");
        jndiProperties.put("java.naming.provider.url", "remote+http://localhost:8080");
        InitialContext context = new InitialContext(jndiProperties);
        return (RemoteCalculator)context.lookup("ejb:/ejb-remote-server-side/CalculatorBean!" + RemoteCalculator.class.getName());
    }

    private static RemoteCounter lookupRemoteStatefulCounter() throws NamingException {
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.initial", "org.wildfly.naming.client.WildFlyInitialContextFactory");
        jndiProperties.put("java.naming.provider.url", "remote+http://localhost:8080");
        InitialContext context = new InitialContext(jndiProperties);
        return (RemoteCounter)context.lookup("ejb:/ejb-remote-server-side/CounterBean!" + RemoteCounter.class.getName() + "?stateful");
    }
}

