/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ha.singleton;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ScheduleExpression;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Startup
@Singleton
public class SingletonTimer {
    private static final Logger LOGGER = Logger.getLogger(SingletonTimer.class.toString());
    @Resource
    private TimerService timerService;

    @PostConstruct
    public void initialize() {
        LOGGER.warning("SingletonTimer is initializing.");
        ScheduleExpression scheduleExpression = new ScheduleExpression().hour("*").minute("*").second("0/5");
        TimerConfig test = new TimerConfig((Serializable)((Object)"Hello World!"), false);
        this.timerService.createCalendarTimer(scheduleExpression, test);
    }

    @Timeout
    public void scheduler(Timer timer) {
        LOGGER.info("SingletonTimer: " + timer.getInfo());
    }

    @PreDestroy
    public void stop() {
        LOGGER.warning("SingletonTimer is stopping: the server is either being shutdown or another node has become elected to be the singleton master.");
    }
}

