/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ha.singleton.service.backups;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;

class SingletonService
implements Service<Node> {
    private Logger LOG = Logger.getLogger(this.getClass());
    private ScheduledExecutorService executor;
    private InjectedValue<Group> group;
    private boolean primary;

    SingletonService(boolean primary, InjectedValue<Group> group) {
        this.primary = primary;
        this.group = group;
    }

    public void start(StartContext context) throws StartException {
        this.LOG.infof("%s singleton service is starting.", (Object)this.serviceType());
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(() -> this.LOG.infof("%s singleton service is running on node '%s'.", (Object)this.serviceType(), (Object)this.getValue()), 5L, 5L, TimeUnit.SECONDS);
    }

    public void stop(StopContext context) {
        this.LOG.infof("%s singleton service is stopping.", (Object)this.serviceType());
        this.executor.shutdown();
    }

    public Node getValue() throws IllegalStateException, IllegalArgumentException {
        return ((Group)this.group.getValue()).getLocalNode();
    }

    private String serviceType() {
        return this.primary ? "Primary" : "Backup";
    }
}

