/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.helloworld;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jboss.as.quickstarts.helloworld.HelloService;

/*
 * Exception performing whole class analysis ignored.
 */
@WebServlet(value={"/HelloWorld"})
public class HelloWorldServlet
extends HttpServlet {
    static String PAGE_HEADER = "<html><head><title>helloworld</title></head><body>";
    static String PAGE_FOOTER = "</body></html>";
    @Inject
    HelloService helloService;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.println(PAGE_HEADER);
        writer.println("<h2>" + this.helloService.createHelloMessage("World ") + "</h2>");
        writer.println("<h4> Caller Principal: " + req.getUserPrincipal() + "</h4>");
        writer.println("<h4> Client Certificate Pem: " + HelloWorldServlet.getPemFromCertificate((X509Certificate)this.extractCertificate(req)) + "</h4>");
        writer.println(PAGE_FOOTER);
        writer.close();
    }

    protected X509Certificate extractCertificate(HttpServletRequest req) {
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        throw new RuntimeException("No X.509 client certificate found in request");
    }

    public static String getPemFromCertificate(X509Certificate certificate) {
        if (certificate != null) {
            StringWriter writer = new StringWriter();
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            try {
                pemWriter.writeObject((Object)certificate);
                pemWriter.flush();
                pemWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String s = writer.toString();
            return HelloWorldServlet.removeBeginEnd((String)s);
        }
        return null;
    }

    public static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }
}

