/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.cmt.jts.ejb;

import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.JMSException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.as.quickstarts.cmt.jts.ejb.InvoiceManagerEJB;
import org.jboss.as.quickstarts.cmt.jts.ejb.InvoiceManagerEJBHome;
import org.jboss.as.quickstarts.cmt.model.Customer;

@Stateless
public class CustomerManagerEJB {
    @PersistenceContext
    private EntityManager entityManager;
    @EJB(lookup="corbaname:iiop:localhost:3628#jts-quickstart/InvoiceManagerEJBImpl")
    private InvoiceManagerEJBHome invoiceManagerHome;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createCustomer(String name) throws RemoteException, JMSException {
        Customer c1 = new Customer();
        c1.setName(name);
        this.entityManager.persist((Object)c1);
        InvoiceManagerEJB invoiceManager = this.invoiceManagerHome.create();
        invoiceManager.createInvoice(name);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<Customer> listCustomers() {
        return this.entityManager.createQuery("select c from Customer c").getResultList();
    }
}

