/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.quickstarts.security_domain_to_domain.ejb;

import java.security.Principal;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.jboss.ejb3.annotation.SecurityDomain;

@Stateless
@SecurityDomain(value="BusinessDomain")
public class ManagementBean {
    @Resource
    private SessionContext sessionContext;

    @PermitAll
    public Principal getCallerPrincipal() {
        return this.sessionContext.getCallerPrincipal();
    }

    @PermitAll
    public boolean userHasRole(String roleName) {
        return this.sessionContext.isCallerInRole(roleName);
    }
}

