/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.quickstarts.security_domain_to_domain.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.quickstarts.security_domain_to_domain.ejb.ManagementBean;

@WebServlet(value={"/SecuredServlet"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"User"}))
public class SecuredServlet
extends HttpServlet {
    @EJB
    private ManagementBean bean;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter writer = resp.getWriter();
        writer.println("<html><head><title>security-domain-to-domain</title></head><body>");
        writer.println("<h1>Successfully called Secured Servlet </h1>");
        writer.println("<h2>Identity as visible to servlet.</h2>");
        writer.println(String.format("<p>Principal  : %s</p>", req.getUserPrincipal().getName()));
        writer.println(String.format("<p>Remote User : %s</p>", req.getRemoteUser()));
        writer.println(String.format("<p>Authentication Type : %s</p>", req.getAuthType()));
        writer.println(String.format("<p>Caller Has Role '%s'=%b</p>", "User", req.isUserInRole("User")));
        writer.println(String.format("<p>Caller Has Role '%s'=%b</p>", "Manager", req.isUserInRole("Manager")));
        writer.println("<h2>Identity as visible to EJB.</h2>");
        writer.println(String.format("<p>Principal  : %s</p>", this.bean.getCallerPrincipal().getName()));
        writer.println(String.format("<p>Caller Has Role '%s'=%b</p>", "User", this.bean.userHasRole("User")));
        writer.println(String.format("<p>Caller Has Role '%s'=%b</p>", "Manager", this.bean.userHasRole("Manager")));
        writer.println("</body></html>");
        writer.close();
    }
}

