/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.quickstarts.security_domain_to_domain.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

@WebFilter(urlPatterns={"/*"})
public class IdentityFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecurityIdentity identity = SecurityDomain.getCurrent().getCurrentSecurityIdentity();
        try {
            identity.runAs(() -> {
                try {
                    chain.doFilter(request, response);
                }
                catch (IOException | ServletException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    public void destroy() {
    }
}

