/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.spring.matrixvariables.data;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import org.jboss.as.quickstarts.kitchensink.spring.matrixvariables.data.MemberDao;
import org.jboss.as.quickstarts.kitchensink.spring.matrixvariables.model.Member;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class MemberDaoImpl
implements MemberDao {
    private static final Logger log = Logger.getLogger(MemberDaoImpl.class.getName());
    @Autowired
    private EntityManager em;

    public Member findById(Long id) {
        return (Member)this.em.find(Member.class, (Object)id);
    }

    public List<Member> findByNameAndEmail(String name, String email) {
        log.fine("findByNameAndEmail name = " + name + ", email = " + email);
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        EntityType type = this.em.getMetamodel().entity(Member.class);
        Root member = criteria.from(Member.class);
        ArrayList<Predicate> predicatesList = new ArrayList<Predicate>();
        if (name != null && !name.isEmpty()) {
            Predicate isLikeName = cb.like(cb.lower((Expression)member.get(type.getDeclaredSingularAttribute("name", String.class))), "%" + name.toLowerCase() + "%");
            predicatesList.add(isLikeName);
        }
        if (email != null && !email.isEmpty()) {
            Predicate isLikeEmail = cb.like(cb.lower((Expression)member.get(type.getDeclaredSingularAttribute("email", String.class))), "%" + email.toLowerCase() + "%");
            predicatesList.add(isLikeEmail);
        }
        criteria.where(predicatesList.toArray(new Predicate[predicatesList.size()]));
        return this.em.createQuery(criteria).getResultList();
    }

    public Member findByEmail(String email) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        Root member = criteria.from(Member.class);
        criteria.select((Selection)member).where((Expression)cb.equal((Expression)member.get("email"), (Object)email));
        return (Member)this.em.createQuery(criteria).getSingleResult();
    }

    public List<Member> findAllOrderedByName() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        Root member = criteria.from(Member.class);
        criteria.select((Selection)member).orderBy(new Order[]{cb.asc((Expression)member.get("name"))});
        return this.em.createQuery(criteria).getResultList();
    }

    public void register(Member member) {
        this.em.persist((Object)member);
    }
}

