/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.tasksJsf;

import javax.enterprise.context.Conversation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.tasksJsf.Authentication;
import org.jboss.as.quickstarts.tasksJsf.CurrentUser;
import org.jboss.as.quickstarts.tasksJsf.User;
import org.jboss.as.quickstarts.tasksJsf.UserDao;

@Named
@RequestScoped
public class AuthController {
    @Inject
    private Authentication authentication;
    @Inject
    private UserDao userDao;
    @Inject
    private FacesContext facesContext;
    @Inject
    private Conversation conversation;

    @Produces
    @Named
    @CurrentUser
    public User getCurrentUser() {
        return this.authentication.getCurrentUser();
    }

    public void authenticate(String username) {
        if (this.isLogged()) {
            throw new IllegalStateException("User is logged and tries to authenticate again");
        }
        User user = this.userDao.getForUsername(username);
        if (user == null) {
            user = this.createUser(username);
        }
        this.authentication.setCurrentUser(user);
        this.conversation.begin();
    }

    public void logout() {
        this.authentication.setCurrentUser(null);
        this.conversation.end();
    }

    public boolean isLogged() {
        return this.authentication.getCurrentUser() != null;
    }

    private User createUser(String username) {
        try {
            User user = new User(username);
            this.userDao.createUser(user);
            this.facesContext.addMessage(null, new FacesMessage("User successfully created"));
            return user;
        }
        catch (Exception e) {
            this.facesContext.addMessage(null, new FacesMessage("Failed to create user '" + username + "'", e.getMessage()));
            return null;
        }
    }
}

