/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.tasksJsf;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.tasksJsf.CurrentTaskStore;
import org.jboss.as.quickstarts.tasksJsf.CurrentUser;
import org.jboss.as.quickstarts.tasksJsf.Task;
import org.jboss.as.quickstarts.tasksJsf.TaskDao;
import org.jboss.as.quickstarts.tasksJsf.TaskList;
import org.jboss.as.quickstarts.tasksJsf.User;

@RequestScoped
@Named
public class TaskController {
    @Inject
    private TaskDao taskDao;
    @Inject
    private TaskList taskList;
    @Inject
    @CurrentUser
    private Instance<User> currentUser;
    @Inject
    private CurrentTaskStore currentTaskStore;

    public void setCurrentTask(Task task) {
        this.currentTaskStore.set(task);
    }

    public void createTask(String taskTitle) {
        this.taskList.invalidate();
        Task task = new Task(taskTitle);
        this.taskDao.createTask((User)this.currentUser.get(), task);
        if (this.currentTaskStore.get() == null) {
            this.currentTaskStore.set(task);
        }
    }

    public void deleteTask(Task task) {
        this.taskList.invalidate();
        if (task.equals((Object)this.currentTaskStore.get())) {
            this.currentTaskStore.unset();
        }
        this.taskDao.deleteTask(task);
    }

    public void deleteCurrentTask() {
        this.deleteTask(this.currentTaskStore.get());
    }
}

