/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.tasksrs.service;

import java.net.URI;
import java.security.Principal;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.as.quickstarts.tasksrs.model.Task;
import org.jboss.as.quickstarts.tasksrs.model.TaskDao;
import org.jboss.as.quickstarts.tasksrs.model.User;
import org.jboss.as.quickstarts.tasksrs.model.UserDao;

@Path(value="/")
public class TaskResource {
    @Inject
    private UserDao userDao;
    @Inject
    private TaskDao taskDao;

    @POST
    @Path(value="tasks/title/{title}")
    public Response createTask(@Context UriInfo info, @Context SecurityContext context, @PathParam(value="title") @DefaultValue(value="task") String taskTitle) {
        User user = this.getUser(context);
        Task task = new Task(taskTitle);
        this.taskDao.createTask(user, task);
        String rawPath = info.getAbsolutePath().getRawPath().replace("title/" + task.getTitle(), "id/" + task.getId().toString());
        UriBuilder uriBuilder = info.getAbsolutePathBuilder().replacePath(rawPath);
        URI uri = uriBuilder.build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    @DELETE
    @Path(value="tasks/id/{id}")
    public void deleteTaskById(@Context SecurityContext context, @PathParam(value="id") Long id) {
        Task task = this.getTaskById(context, id);
        this.taskDao.deleteTask(task);
    }

    @GET
    @Path(value="tasks/id/{id}")
    @Produces(value={"application/xml"})
    public Task getTaskById(@Context SecurityContext context, @PathParam(value="id") Long id) {
        User user = this.getUser(context);
        return this.getTask(user, id);
    }

    @GET
    @Path(value="tasks/title/{title}")
    @Produces(value={"application/xml"})
    public List<Task> getTasksByTitle(@Context SecurityContext context, @PathParam(value="title") String title) {
        return this.getTasks(this.getUser(context), title);
    }

    @GET
    @Path(value="tasks/title")
    @Produces(value={"application/xml"})
    public List<Task> getTasks(@Context SecurityContext context) {
        return this.getTasks(this.getUser(context));
    }

    private List<Task> getTasks(User user, String title) {
        return this.taskDao.getForTitle(user, title);
    }

    private List<Task> getTasks(User user) {
        return this.taskDao.getAll(user);
    }

    private Task getTask(User user, Long id) {
        for (Task task : this.taskDao.getAll(user)) {
            if (!task.getId().equals(id)) continue;
            return task;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private User getUser(SecurityContext context) {
        Principal principal = null;
        if (context != null) {
            principal = context.getUserPrincipal();
        }
        if (principal == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return this.getUser(principal.getName());
    }

    private User getUser(String username) {
        try {
            User user = this.userDao.getForUsername(username);
            if (user == null) {
                user = new User(username);
                this.userDao.createUser(user);
            }
            return user;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

