/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.xml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.as.quickstart.xml.Book;
import org.jboss.as.quickstart.xml.Errors;
import org.jboss.as.quickstart.xml.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

@RequestScoped
@Default
public class DOMXMLParser
extends XMLParser {
    @Inject
    private Errors errorHolder;
    private DocumentBuilder builder;
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    DOMXMLParser() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        this.builder = factory.newDocumentBuilder();
        this.builder.setErrorHandler((ErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Book> parseInternal(InputStream is) throws Exception {
        System.out.println("Parsing the document using the DOMXMLParser!");
        Document document = this.builder.parse(is);
        ArrayList<Book> catalog = new ArrayList<Book>();
        Element root = document.getDocumentElement();
        if (!root.getLocalName().equals("catalog")) {
            throw new RuntimeException("Wrong element: " + root.getTagName());
        }
        NodeList children = root.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node n = children.item(index);
            String childName = n.getLocalName();
            if (childName == null || !n.getLocalName().equals("book")) continue;
            Book b = this.parseBook((Element)n);
            catalog.add(b);
        }
        return catalog;
    }

    private Book parseBook(Element n) {
        Book b = new Book();
        NodeList children = n.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            String textVal;
            Element childElement;
            Node child = children.item(index);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("author")) {
                childElement = (Element)child;
                textVal = this.getTextValue(childElement);
                b.setAuthor(textVal);
                continue;
            }
            if (childName.equals("title")) {
                childElement = (Element)child;
                textVal = this.getTextValue(childElement);
                b.setTitle(textVal);
                continue;
            }
            if (childName.equals("genre")) {
                childElement = (Element)child;
                textVal = this.getTextValue(childElement);
                b.setGenre(textVal);
                continue;
            }
            if (childName.equals("price")) {
                childElement = (Element)child;
                textVal = this.getTextValue(childElement);
                b.setPrice(Float.parseFloat(textVal));
                continue;
            }
            if (childName.equals("publish_date")) {
                childElement = (Element)child;
                textVal = this.getTextValue(childElement);
                try {
                    Date d = DATE_FORMATTER.parse(textVal);
                    b.setPublishDate(d);
                    continue;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!childName.equals("description")) continue;
            childElement = (Element)child;
            textVal = this.getTextValue(childElement);
            b.setDescription(textVal);
        }
        return b;
    }

    private String getTextValue(Element childElement) {
        Node node;
        NodeList nl = childElement.getChildNodes();
        if (nl != null && nl.getLength() > 0 && (node = nl.item(0)).getNodeType() == 3) {
            return node.getNodeValue();
        }
        return "";
    }

    static /* synthetic */ Errors access$000(DOMXMLParser x0) {
        return x0.errorHolder;
    }
}

